/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetProcessor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.ac;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import org.apache.log4j.NDC;

public abstract class Svn2ChangesetProcessor
implements ChangeSetProcessor {
    protected void updateIndexingState(SvnChangeSetDAO changeSetDAO, long csid) {
        changeSetDAO.updateIndexingState(Long.toString(csid), this.getVersion(), this.getResultingState());
    }

    protected boolean checkIndexingState(String csid, ChangeSetIndexingState currentState) {
        ChangeSetIndexingState requiredState = this.getResultingState().previous();
        if (currentState != requiredState) {
            String message = "Changeset " + csid + " is not in correct state (it is " + (Object)((Object)currentState) + ") for this processor: " + this.getClass().getSimpleName() + ". Should be " + (Object)((Object)requiredState);
            Logs.APP_LOG.error((Object)message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean processChangesetEntry(RepositoryHandle handle, ChangeSetEntry entry) throws RepositoryHandle.StateException {
        if (!handle.isRunning()) {
            return false;
        }
        ChangeSetIndexingState nextState = this.getResultingState();
        Timer timer = new Timer(nextState.toString() + " Processing " + entry.getId());
        NDC.push((String)handle.getName());
        Svn2RepositoryEngine engine = null;
        Disposer.pushThreadInstance();
        try {
            boolean processed;
            long end;
            long start;
            engine = (Svn2RepositoryEngine)handle.acquireEngine();
            handle.getStatus().throwOnStopRequested();
            Svn2Cache cache = (Svn2Cache)engine.getInternalRevisionCache();
            if (entry.isRange()) {
                start = Long.parseLong(entry.getFromID());
                end = Long.parseLong(entry.getToID());
            } else {
                start = end = Long.parseLong(entry.getId());
            }
            SvnChangeSetDAO changesetDAO = cache.getChangeSetDAO();
            LongSortedSet csids = changesetDAO.getSvnChangeSetIds(start, end);
            LongRBTreeSet alreadyProcessedCsids = new LongRBTreeSet();
            LongRBTreeSet toProcessCsids = new LongRBTreeSet();
            this.classifyChangesets(cache, csids, (LongSortedSet)alreadyProcessedCsids, (LongSortedSet)toProcessCsids);
            if (!alreadyProcessedCsids.isEmpty()) {
                cache.withDbWriteLock(this.getDbLockPriority(), new DbTask<Void>((LongSortedSet)alreadyProcessedCsids, changesetDAO){
                    final /* synthetic */ LongSortedSet val$alreadyProcessedCsids;
                    final /* synthetic */ SvnChangeSetDAO val$changesetDAO;
                    {
                        this.val$alreadyProcessedCsids = longSortedSet;
                        this.val$changesetDAO = svnChangeSetDAO;
                    }

                    @Override
                    public Void perform(ac itemSpace) {
                        LongBidirectionalIterator longBidirectionalIterator = this.val$alreadyProcessedCsids.iterator();
                        while (longBidirectionalIterator.hasNext()) {
                            long csid = (Long)longBidirectionalIterator.next();
                            Svn2ChangesetProcessor.this.updateIndexingState(this.val$changesetDAO, csid);
                        }
                        return null;
                    }
                });
            }
            if (!toProcessCsids.isEmpty()) {
                processed = this.processChangesets(engine, (LongSortedSet)toProcessCsids);
                engine.getStatus().setMessage("");
                Logs.APP_LOG.info((Object)("Done " + (Object)((Object)nextState) + " Processing " + entry.getId() + " result = " + processed));
            } else {
                processed = true;
            }
            boolean bl = processed;
            return bl;
        }
        catch (StopRequestedException e2) {
            boolean bl = false;
            return bl;
        }
        catch (CancellationException e3) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e4) {
            if (!handle.getStatus().isStopRequested()) {
                Logs.APP_LOG.error((Object)("Error processing changeset " + entry.getId()), (Throwable)e4);
                if (engine != null) {
                    engine.startPause(e4);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                timer.end();
                NDC.pop();
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    private void classifyChangesets(Svn2Cache cache, LongSortedSet csids, LongSortedSet alreadyProcessedCsids, LongSortedSet toProcessCsids) {
        ChangeSetIndexingState nextState = this.getResultingState();
        SvnChangeSetDAO changesetDAO = cache.getChangeSetDAO();
        LongBidirectionalIterator longBidirectionalIterator = csids.iterator();
        while (longBidirectionalIterator.hasNext()) {
            ChangeSetIndexingState currentIndexingState;
            long longCsid = (Long)longBidirectionalIterator.next();
            String csid = Long.toString(longCsid);
            if (!changesetDAO.exists(csid) || (currentIndexingState = changesetDAO.getIndexingState(csid)) == nextState) continue;
            Long handlerVersion = changesetDAO.getChangesetHandlerVersion(csid, nextState);
            if (handlerVersion == null || handlerVersion.longValue() != this.getVersion()) {
                if (!this.checkIndexingState(csid, currentIndexingState)) continue;
                toProcessCsids.add(longCsid);
                continue;
            }
            alreadyProcessedCsids.add(longCsid);
        }
    }

    protected abstract boolean processChangesets(Svn2RepositoryEngine var1, LongSortedSet var2) throws RepositoryClientException, LicensePolicyException, IOException;

    protected abstract ChangeSetIndexingState getResultingState();

    protected abstract long getVersion();

    protected abstract int getDbLockPriority();
}

