/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2MessageContext;
import com.atlassian.fisheye.svn.SvnPathInfo;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.SvnAction;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.types.NodeKind;

public class Svn2ChangesetDiffSummary {
    private final long maxDiffSize;
    private final Svn2MessageContext context;
    private boolean hasExcludedPaths;
    private final Map<Path, DiffSummary.DiffKind> propertyChanges = new HashMap<Path, DiffSummary.DiffKind>();
    private final Map<Path, DiffInfo> diffPaths = new HashMap<Path, DiffInfo>();
    private final Set<Path> dirPaths = new HashSet<Path>();
    private boolean hasCopiedPaths;
    private boolean hasDeletedPaths;
    private boolean hasDiffPaths;
    private boolean hasDirectoryCopyTag;
    private boolean hasPreviousRevMissing;
    private final Predicate<DiffInfo> isCopy = new Predicate<DiffInfo>(){

        public boolean apply(@Nullable DiffInfo input) {
            if (input == null) {
                return false;
            }
            SvnChangePath controllingChange = input.controllingChange;
            if (input.diffKind.equals((Object)DiffSummary.DiffKind.added) && controllingChange.getCopySrcPath() != null) {
                Path srcPath = Svn2ChangesetDiffSummary.this.context.getRepositoryInfo().getLocalPath(controllingChange.getCopySrcPath(), controllingChange.getCopySrcRevision());
                return !Svn2ChangesetDiffSummary.this.context.getRepositoryInfo().getPathMatcher().isTag(srcPath);
            }
            return false;
        }
    };
    private final Predicate<DiffInfo> isDelete = new Predicate<DiffInfo>(){

        public boolean apply(@Nullable DiffInfo input) {
            return input != null && input.diffKind.equals((Object)DiffSummary.DiffKind.deleted);
        }
    };
    private final Predicate<DiffInfo> isDiffRequiring = new Predicate<DiffInfo>(){

        public boolean apply(@Nullable DiffInfo input) {
            if (input == null) {
                return false;
            }
            if (!input.diffKind.equals((Object)DiffSummary.DiffKind.deleted)) {
                String copySrcPath = input.controllingChange.getCopySrcPath();
                if (copySrcPath == null) {
                    return true;
                }
                SvnRepositoryInfo repositoryInfo = Svn2ChangesetDiffSummary.this.context.getRepositoryInfo();
                SvnLogicalPathMatcher pathMatcher = repositoryInfo.getPathMatcher();
                if (pathMatcher.isTag(input.path)) {
                    return false;
                }
                if (input.controllingChange.getNodeKind() != NodeKind.dir) {
                    return true;
                }
                Path srcPath = repositoryInfo.getLocalPath(copySrcPath, Svn2ChangesetDiffSummary.this.context.getRevision());
                return pathMatcher.isTag(srcPath);
            }
            return false;
        }
    };
    private final Predicate<DiffInfo> isDirectoryCopyTag = new Predicate<DiffInfo>(){

        public boolean apply(@Nullable DiffInfo input) {
            return input != null && input.controllingChange != null && input.controllingChange.getNodeKind() == NodeKind.dir && input.controllingChange.getCopySrcPath() != null && Svn2ChangesetDiffSummary.this.context.getRepositoryInfo().getPathMatcher().isTag(input.path);
        }
    };

    public Svn2ChangesetDiffSummary(Svn2MessageContext context) {
        this.context = context;
        this.maxDiffSize = context.getRepositoryInfo().getMaxIndexableSize();
    }

    public void setHasExcludedPaths(boolean hasExcludedPaths) {
        this.hasExcludedPaths = hasExcludedPaths;
    }

    public void addPropertyChanged(Path path, DiffSummary.DiffKind diffKind) {
        this.propertyChanges.put(path, diffKind);
        Logs.APP_LOG.debug((Object)("Adding diff kind " + diffKind + " for path " + path));
    }

    public Map<Path, DiffSummary.DiffKind> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void addDiffPath(Path path, SvnChangePath controllingChange, DiffSummary.DiffKind diffKind, NodeKind nodeKind, SvnPathInfo info) {
        SvnLogicalPathMatcher pathMatcher = this.context.getRepositoryInfo().getPathMatcher();
        if (SvnAction.isAddAction(controllingChange.getAction()) && pathMatcher.isTag(path) && !pathMatcher.isTagRoot(path)) {
            if (controllingChange.getCopySrcPath() != null) {
                return;
            }
            Path tagRoot = pathMatcher.getTagRoot(path);
            Path controllingPath = this.context.getRepositoryInfo().getLocalPath(controllingChange.getPath(), this.context.getRevision());
            if (controllingPath.equals(tagRoot) || controllingPath.isAncestor(tagRoot)) {
                return;
            }
        }
        DiffInfo diffInfo = new DiffInfo(path, controllingChange, diffKind, nodeKind, info);
        if (this.diffPaths.containsKey(path)) {
            if (diffKind.equals((Object)DiffSummary.DiffKind.added)) {
                this.diffPaths.put(path, diffInfo);
            }
        } else {
            this.diffPaths.put(path, diffInfo);
        }
        this.hasCopiedPaths = this.hasCopiedPaths || this.isCopy.apply((Object)diffInfo);
        this.hasDeletedPaths = this.hasDeletedPaths || this.isDelete.apply((Object)diffInfo);
        this.hasDiffPaths = this.hasDiffPaths || this.isDiffRequiring.apply((Object)diffInfo);
        boolean bl = this.hasDirectoryCopyTag = this.hasDirectoryCopyTag || this.isDirectoryCopyTag.apply((Object)diffInfo);
        if (info != null && info.getKind() == NodeKind.dir || nodeKind == NodeKind.dir) {
            this.dirPaths.add(path);
        }
    }

    public boolean hasCopiedPaths() {
        return this.hasCopiedPaths;
    }

    public Iterable<Path> getCopiedPaths() {
        return this.filterPaths(this.isCopy);
    }

    public SvnChangePath getControllingChange(Path path) {
        return this.diffPaths.get(path).controllingChange;
    }

    public boolean isControllingPath(Path path) {
        Path controllingPath = this.context.getLocalPath(this.diffPaths.get(path).controllingChange);
        return controllingPath.equals(path);
    }

    public DiffSummary.DiffKind getDiffKind(Path path) {
        return this.diffPaths.get(path).diffKind;
    }

    public SvnPathInfo getInfo(Path path) {
        return this.diffPaths.get(path).info;
    }

    public void setInfo(Path path, SvnPathInfo info) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        if (diffInfo != null) {
            diffInfo.info = info;
        }
    }

    public void setParentBinaryOversize(Path path, boolean parentOversize, boolean parentBinary) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        if (diffInfo != null) {
            diffInfo.parentOversized = parentOversize;
            diffInfo.parentBinary = parentBinary;
        }
    }

    public boolean isDiffOversize(Path path) {
        return this.isOversize(path) || this.isParentOversize(path);
    }

    public boolean isOversize(Path path) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        SvnPathInfo info = diffInfo.info;
        if (info == null) {
            return false;
        }
        return info.getReposSize() > this.maxDiffSize;
    }

    public boolean isParentOversize(Path path) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        return diffInfo.parentOversized;
    }

    public boolean isParentBinary(Path path) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        return diffInfo.parentBinary;
    }

    public void setPreviousRevMissing(Path path, boolean previousRevMissing) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        if (diffInfo != null) {
            diffInfo.previousRevMissing = previousRevMissing;
            this.hasPreviousRevMissing |= previousRevMissing;
        }
    }

    public boolean isPreviousRevMissing(Path path) {
        DiffInfo diffInfo = this.diffPaths.get(path);
        return diffInfo != null && diffInfo.previousRevMissing;
    }

    public Iterable<Path> getDiffPaths() {
        return this.filterPaths(this.isDiffRequiring);
    }

    public Iterable<Path> getAllPaths() {
        return this.diffPaths.keySet();
    }

    public Iterable<SvnChangePath> getDiffControllingChanges() {
        return this.filterControllingChanges(this.isDiffRequiring);
    }

    public boolean hasDiffPaths() {
        return this.hasDiffPaths;
    }

    public Iterable<Path> getDeletedPaths() {
        return this.filterPaths(this.isDelete);
    }

    public boolean hasDeletedPaths() {
        return this.hasDeletedPaths;
    }

    private Iterable<SvnChangePath> filterControllingChanges(Predicate<DiffInfo> predicate) {
        HashSet<SvnChangePath> controllingChanges = new HashSet<SvnChangePath>();
        for (Map.Entry<Path, DiffInfo> entry : this.diffPaths.entrySet()) {
            DiffInfo info = entry.getValue();
            if (!predicate.apply((Object)info)) continue;
            controllingChanges.add(info.controllingChange);
        }
        return controllingChanges;
    }

    public Iterable<Path> filterPaths(final Predicate<DiffInfo> predicate) {
        return Iterables.filter(this.diffPaths.keySet(), (Predicate)new Predicate<Path>(){

            public boolean apply(@Nullable Path input) {
                return predicate.apply(Svn2ChangesetDiffSummary.this.diffPaths.get(input));
            }
        });
    }

    public boolean canDoCombinedDiff() {
        if (this.hasExcludedPaths || this.pathsContainOversizedDiffs()) {
            return false;
        }
        if (this.context.isStartRevWithNoImport() && this.hasPreviousRevMissing) {
            return false;
        }
        int numDiffablePaths = Iterables.size(this.getDiffPaths());
        int numPaths = this.diffPaths.size();
        if (this.hasDirectoryCopyTag) {
            return numDiffablePaths > FishEyeSysProps.SVN_TAG_COMBINED_DIFF_THRESHOLD;
        }
        return numDiffablePaths > numPaths / 2;
    }

    private boolean pathsContainOversizedDiffs() {
        for (Path path : this.diffPaths.keySet()) {
            if (!this.isDiffOversize(path)) continue;
            return true;
        }
        return false;
    }

    public boolean isDir(Path path) {
        return this.dirPaths.contains(path);
    }

    public Set<Path> getDirPaths() {
        return this.dirPaths;
    }

    public boolean isFullDiffRequired(Path path) {
        return this.context.isStartRevWithNoImport() && this.isPreviousRevMissing(path);
    }

    private static class DiffInfo {
        private final Path path;
        private final SvnChangePath controllingChange;
        private final DiffSummary.DiffKind diffKind;
        private final NodeKind nodeKind;
        private SvnPathInfo info;
        private boolean parentOversized;
        private boolean parentBinary;
        private boolean previousRevMissing;

        public DiffInfo(Path path, SvnChangePath controllingChange, DiffSummary.DiffKind diffKind, NodeKind nodeKind, SvnPathInfo info) {
            this.path = path;
            this.controllingChange = controllingChange;
            this.diffKind = diffKind;
            this.nodeKind = nodeKind;
            this.info = info;
        }
    }
}

