/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.svn.Svn2ClientPool;
import com.atlassian.fisheye.svn.Svn2FileHistory;
import com.cenqua.crucible.util.HelpUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.BaseDirInfoCache;
import com.cenqua.fisheye.cache.RevisionIdentifier;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.cenqua.fisheye.rep.SyntheticBlameInfo;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.SuffixSearchUtil;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnMimeUtils;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.db.SvnSchema;
import com.cenqua.fisheye.svn.db.SvnStringTables;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.types.Revision;

public class Svn2Cache
extends BaseDirInfoCache<SvnRevInfo, SvnChangeSet, SvnStringTables> {
    private SvnRepositoryInfo repositoryInfo;
    private final Svn2ClientPool clientPool;
    private SvnRevInfoDAO fileRevDAO;
    private SvnChangeSetDAO csDAO;
    private long latestRevision;
    private ReentrantLock diffTextLock = new ReentrantLock();
    private final AtomicBoolean supportedBlameMergeInfo = new AtomicBoolean(true);

    protected Svn2Cache(long cacheSerial, int version, InfinityDbHandle dbh, LuceneConnection<LuceneIndexes> luceneConnection, LicenseEnforcer licenseEnforcer, IndexingContext indexingContext, SvnRepositoryInfo repositoryInfo, Svn2ClientPool clientPool) {
        super(repositoryInfo.getConfig().getStatus(), cacheSerial, version, dbh, luceneConnection, new SvnStringTables(dbh), licenseEnforcer, indexingContext, repositoryInfo.isCaseSensitive());
        this.repositoryInfo = repositoryInfo;
        this.clientPool = clientPool;
        this.fileRevDAO = new SvnRevInfoDAO(this.getInfDb(), (SvnStringTables)this.getStringTables(), repositoryInfo.getPathMatcher(), repositoryInfo.getName(), this.getLicenseEnforcer());
        this.csDAO = new SvnChangeSetDAO(repositoryInfo.getConfig().getStatus(), this.getInfDb(), (SvnStringTables)this.getStringTables(), this.getFileRevisionDAO(), this.getLicenseEnforcer());
        this.latestRevision = -1L;
    }

    public ReentrantLock getDiffTextLock() {
        return this.diffTextLock;
    }

    @Override
    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.fileRevDAO.getCommonRevInfoDAO();
    }

    public SvnChangeSetDAO getChangeSetDAO() {
        return this.csDAO;
    }

    @Override
    public SvnRevInfoDAO getFileRevisionDAO() {
        return this.fileRevDAO;
    }

    @Override
    public FileRevision findFileRevision(Path path, String revision) throws DbException {
        if (StringUtils.isEmpty((String)revision)) {
            return null;
        }
        FileRevision fileRevision = super.findFileRevision(path, revision);
        if (fileRevision == null) {
            try {
                long rev = Long.parseLong(revision);
                long latestLogical = -1L;
                Path logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(path);
                if (logicalPath != null && (latestLogical = this.fileRevDAO.getLatestLogicalPathChangeUpto(logicalPath, rev)) == rev) {
                    fileRevision = this.getLogicalFileRevision(logicalPath, rev);
                }
                if (fileRevision == null) {
                    long latestPathChangeUpto = this.fileRevDAO.getLatestPathChangeUpto(path, rev, false);
                    if (latestPathChangeUpto != -1L) {
                        fileRevision = this.getFileRevision(new RevInfoKey(path, String.valueOf(latestPathChangeUpto)));
                    } else if (latestLogical != -1L) {
                        fileRevision = this.getLogicalFileRevision(logicalPath, latestLogical);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fileRevision;
    }

    @Override
    public FileRevision getFileRevisionAtTag(Path physicalPath, String tag) {
        FileRevision fileRevision = super.getFileRevisionAtTag(physicalPath, tag);
        if (fileRevision == null) {
            int revid = this.fileRevDAO.getRevId(physicalPath, -1L);
            fileRevision = this.getFileRevision(revid);
        }
        return fileRevision;
    }

    private FileRevision getLogicalFileRevision(Path logicalPath, long rev) {
        SvnRevInfo fileRevision = null;
        int logicalRevId = this.fileRevDAO.getLogicalPathRevid(logicalPath, rev);
        if (logicalRevId != -1) {
            fileRevision = this.fileRevDAO.load(logicalRevId);
        }
        return fileRevision;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryInfo.getName();
    }

    @Override
    @Nullable
    public String getDefaultBranch() {
        if (this.hasBranch("trunk")) {
            return "trunk";
        }
        return null;
    }

    @Override
    public Path[] listFiles(Path dir) throws DbException {
        Path[] pathArray;
        Path tagRoot = this.repositoryInfo.getPathMatcher().getTagRoot(dir);
        if (tagRoot == null) {
            pathArray = super.listFiles(dir);
        } else {
            String tag = this.repositoryInfo.getPathMatcher().getTag(dir);
            Path logicalDir = this.repositoryInfo.getPathMatcher().getLogicalPath(dir);
            Set<Path> pathSet = this.getTaggedPaths(logicalDir, 1, tag, tagRoot);
            pathArray = pathSet.toArray(new Path[pathSet.size()]);
        }
        return pathArray;
    }

    @Override
    public Path[] listDirs(Path dir) throws DbException {
        Object[] pathArray = super.listDirs(dir);
        Path tagRoot = this.repositoryInfo.getPathMatcher().getTagRoot(dir);
        if (tagRoot != null) {
            String tag = this.repositoryInfo.getPathMatcher().getTag(dir);
            Path logicalDir = this.repositoryInfo.getPathMatcher().getLogicalPath(dir);
            HashSet pathSet = Sets.newHashSet((Object[])pathArray);
            pathSet.addAll(this.getTaggedPaths(logicalDir, 2, tag, tagRoot));
            if (pathSet.contains(dir)) {
                pathSet.remove(dir);
            }
            pathArray = pathSet.toArray(new Path[pathSet.size()]);
        }
        return pathArray;
    }

    private Set<Path> getTaggedPaths(Path logicalDir, int fileType, String tag, Path tagRoot) throws DbException {
        IntList revids = this.fileRevDAO.getTaggedDirEntries(logicalDir, fileType, tag, -1L);
        TreeSet<Path> pathSet = new TreeSet<Path>();
        for (Integer revid : revids) {
            RevInfoKey key = this.getKey(revid);
            Path relativePath = this.repositoryInfo.getPathMatcher().getLogicalTail(key.getPath());
            pathSet.add(new Path(tagRoot, relativePath.getPath()));
        }
        return pathSet;
    }

    @Override
    public boolean isFile(Path path) throws DbException {
        String tag = this.repositoryInfo.getPathMatcher().getTag(path);
        if (tag == null) {
            return this.getPathFileType(path) == 1;
        }
        return this.getTaggedFileType(path, tag) == 1;
    }

    @Override
    public boolean isDir(Path path) throws DbException {
        if (path.isRoot()) {
            return true;
        }
        String tag = this.repositoryInfo.getPathMatcher().getTag(path);
        if (tag == null) {
            return this.getPathFileType(path) == 2;
        }
        return this.getTaggedFileType(path, tag) == 2;
    }

    private int getTaggedFileType(Path physicalPath, String tag) throws DbException {
        Path logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(physicalPath);
        int revid = this.fileRevDAO.getTaggedPathRevid(logicalPath, tag, -1L);
        if (revid == -1) {
            return -1;
        }
        return this.fileRevDAO.getFileType(revid);
    }

    private int getPathFileType(Path path) throws DbException {
        int revid = this.getLastestRevId(path);
        if (revid == -1) {
            return -1;
        }
        return this.fileRevDAO.getFileType(revid);
    }

    @Override
    public void getTextRevision(RevInfoKey key, OutputStream outputStream, String kopt, String symrev) throws IOException, DbException {
        this.getBinaryRevision(key, outputStream);
    }

    @Override
    public void getBinaryRevision(RevInfoKey key, OutputStream outputStream) throws IOException, DbException {
        block9: {
            long revision;
            try {
                revision = Long.parseLong(key.getRev());
            }
            catch (NumberFormatException e2) {
                throw new NotFoundException("file/revision not found: " + key);
            }
            int revid = this.fileRevDAO.getRevId(key.getPath(), revision);
            if (revid == -1 || this.fileRevDAO.isDeleted(revid)) {
                return;
            }
            Revision.Number rev = new Revision.Number(revision);
            SvnThrottledClient client = this.clientPool.allocateClient();
            try {
                if (this.isFile(key.getPath())) {
                    String contentURL = this.repositoryInfo.getPathURL(key.getPath(), revision);
                    client.streamFileContent(contentURL, (Revision)rev, (Revision)rev, outputStream);
                    break block9;
                }
                throw new DbException("Unable to get binary rev for a directory : " + key.getPath());
            }
            catch (RepositoryClientException e3) {
                Logs.APP_LOG.error((Object)("Exception loading SVN content for " + key), (Throwable)e3);
                throw new DbException("SVN Client exception fetching content: " + e3.getMessage(), e3);
            }
            finally {
                this.clientPool.returnClient(client);
            }
        }
    }

    @Override
    public Charset getTextEncoding(RevInfoKey rkey) throws DbException {
        try {
            int revid = this.fileRevDAO.getRevId(rkey.getPath(), Long.parseLong(rkey.getRev()));
            String mimeType = this.fileRevDAO.getSvnProperty(revid, "svn:mime-type");
            Charset charset = SvnMimeUtils.getMimeTypeCharset(mimeType);
            if (charset == null) {
                charset = this.repositoryInfo.getDefaultCharset();
            }
            return charset;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Exception accessing mime-type of " + rkey.getPath()), (Throwable)e2);
            throw new DbException(e2);
        }
    }

    @Override
    public FileRevision getFileRevision(int revid) throws DbException {
        return this.getFileRevision(revid, false);
    }

    @Override
    public FileRevision getFileRevision(int revid, boolean lazy) throws DbException {
        return lazy ? this.fileRevDAO.loadLazy(revid) : this.fileRevDAO.load(revid);
    }

    @Override
    public FileRevision getFileRevision(RevInfoKey rkey) throws DbException {
        long rev;
        if (rkey == null) {
            return null;
        }
        Path path = rkey.getPath();
        try {
            rev = Long.parseLong(rkey.getRev());
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.debug((Object)("Invalid revision: " + rkey));
            return null;
        }
        int revid = this.fileRevDAO.getRevId(path, rev);
        SvnRevInfo revInfo = null;
        if (revid != -1) {
            revInfo = this.fileRevDAO.load(revid);
            if (this.repositoryInfo.getPathMatcher().isTag(path) && !revInfo.getPath().equals(path)) {
                Path tagRoot = this.repositoryInfo.getPathMatcher().getTagRoot(path);
                int tagRootRevid = this.fileRevDAO.getRevId(tagRoot, rev);
                String tagRev = this.fileRevDAO.getRevision(tagRootRevid);
                if (tagRev != null) {
                    revInfo.setSVNRevision(Long.parseLong(tagRev));
                } else {
                    Logs.APP_LOG.warn((Object)("Tag structure inconsistency seen for repository '" + this.getRepositoryName() + "'. This can occur when symbolic structure settings for the repository are changed" + ", but no re-index has been performed. Consider re-indexing this repository."));
                }
            }
        }
        return revInfo;
    }

    @Override
    public String getChangeSetId(int revid) throws DbException {
        return this.fileRevDAO.getRevision(revid);
    }

    @Override
    public SvnRevInfo getLatestFileRevision(Path path) throws DbException {
        int revid = this.getLastestRevId(path);
        SvnRevInfo revInfo = (SvnRevInfo)this.getFileRevision(revid, true);
        return revInfo;
    }

    @Override
    public FileHistory getFullFileHistory(Path path, boolean physicalOnly) throws DbException {
        TreeMultimap ancestry = TreeMultimap.create();
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        boolean useLogical = !physicalOnly || pathMatcher.isTag(path);
        Path logicalPath = useLogical ? pathMatcher.getLogicalPath(path) : null;
        long latestCsid = useLogical && logicalPath != null ? this.fileRevDAO.getLatestLogicalPathChange(logicalPath) : this.fileRevDAO.getLatestPathChange(path);
        RevInfoKey key = new RevInfoKey(path, Long.toString(latestCsid));
        SortedMapFileHistory.addFileAncestry(this, (TreeMultimap<Long, FileRevision>)ancestry, key, true, !useLogical);
        return new Svn2FileHistory(this.repositoryInfo.getPathMatcher(), path, (TreeMultimap<Long, FileRevision>)ancestry);
    }

    @Override
    public Map<Path, String> resolveRevisionsForPatch(Map<Path, RevisionIdentifier> patchRevisions) throws DbException {
        HashMap<Path, String> resolvedCache = new HashMap<Path, String>();
        for (Path path : patchRevisions.keySet()) {
            String revision = this.resolveRevisionForPatch(path, patchRevisions.get(path).getId());
            if (Strings.isNullOrEmpty((String)revision) || "-1".equals(revision)) continue;
            resolvedCache.put(path, revision);
        }
        return resolvedCache;
    }

    private String resolveRevisionForPatch(Path path, String revision) throws DbException {
        try {
            long daoResult = this.fileRevDAO.getLatestPathChangeUpto(path, Long.parseLong(revision), false);
            return String.valueOf(daoResult);
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    @Override
    public Svn2FileHistory getFileHistory(Path physicalPath, boolean physicalOnly) throws DbException {
        TreeMultimap<Long, Integer> csids;
        Path logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(physicalPath);
        String tag = this.repositoryInfo.getPathMatcher().getTag(physicalPath);
        if (physicalOnly || logicalPath == null) {
            csids = TreeMultimap.create();
            for (Map.Entry<Long, Integer> entry : this.fileRevDAO.getPathRevisions(physicalPath).entrySet()) {
                csids.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        } else {
            csids = this.fileRevDAO.getLogicalPathRevisions(logicalPath);
        }
        TreeMultimap history = TreeMultimap.create();
        for (Long csid : csids.keySet()) {
            for (Integer revid : csids.get((Object)csid)) {
                SvnRevInfo revision = this.fileRevDAO.load(revid);
                if (logicalPath != null && !logicalPath.equals(revision.getLogicalPath())) {
                    Logs.APP_LOG.debug((Object)"Skipping revision as logical path did not match");
                    continue;
                }
                boolean includeRevision = tag == null || revision.getTags().contains(tag);
                if (!includeRevision) continue;
                history.put((Object)csid, (Object)revision);
            }
        }
        return new Svn2FileHistory(this.repositoryInfo.getPathMatcher(), physicalPath, (TreeMultimap<Long, FileRevision>)history);
    }

    @Override
    public Blame getBlameFallback(RevInfoKey revInfoKey) throws DbException, IOException {
        FileRevision revision;
        if (revInfoKey == null) {
            throw new IllegalArgumentException("SvnCache.getBlame called with null RevInfoKey");
        }
        int revid = this.getRevId(revInfoKey);
        FileRevision fileRevision = revision = revid == -1 ? null : this.getFileRevision(revid, true);
        if (revision == null) {
            throw new PathNotFoundException("File is not annotatable: revision is null", this.getRepositoryName(), revInfoKey);
        }
        if (!revision.isAnnotatable()) {
            throw new PathNotFoundException("File is not annotatable", this.getRepositoryName(), revInfoKey);
        }
        SvnThrottledClient client = null;
        try {
            client = this.clientPool.allocateClient();
            long rev = Long.parseLong(revInfoKey.getRev());
            List<BlameChunk> chunks = this.getSvnBlameChunks(client, rev, revInfoKey);
            Blame blame = new Blame(chunks);
            return blame;
        }
        catch (RepositoryClientException e2) {
            throw new IOException("Exception getting SVN blame for " + revInfoKey + ": " + e2.getMessage(), e2);
        }
        finally {
            this.clientPool.returnClient(client);
        }
    }

    private List<BlameChunk> getSvnBlameChunks(SvnThrottledClient client, long rev, RevInfoKey contentKey) throws DbException, RepositoryClientException {
        Timer timer = new Timer("getSvnBlameChunks(rev=" + rev + ", contentKey=" + contentKey + ")");
        Revision.Number endRev = new Revision.Number(rev);
        final Path path = contentKey.getPath();
        String pathURL = this.repositoryInfo.getPathURL(path, rev);
        if (pathURL == null) {
            Logs.APP_LOG.warn((Object)("Unable to annotate " + path + "@" + rev + " as the content is not accessible"));
            return Collections.emptyList();
        }
        final LoadingCache fileRevisionCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<RevInfoKey, Optional<FileRevision>>(){

            public Optional<FileRevision> load(RevInfoKey key) throws Exception {
                return Optional.ofNullable(Svn2Cache.this.getFileRevision(key));
            }
        });
        final ArrayList<BlameChunk> chunks = new ArrayList<BlameChunk>();
        BlameCallback callback = new BlameCallback(){
            long currentRev = -1L;
            BlameChunk currentChunk = null;

            public void singleLine(long lineNum, long revision, Map<String, byte[]> revProps, long mergedRevision, Map<String, byte[]> mergedRevProps, String mergedPath, String line, boolean localChange) throws ClientException {
                if (this.currentRev == revision && this.currentChunk.getLength() < 8000) {
                    this.currentChunk.incLength(1);
                } else {
                    String rev = Long.toString(revision);
                    Path revPath = mergedPath != null ? Svn2Cache.this.repositoryInfo.getLocalPath(mergedPath, revision) : path;
                    Optional fileRevision = (Optional)fileRevisionCache.getUnchecked((Object)new RevInfoKey(revPath, rev));
                    this.currentChunk = fileRevision.map(r2 -> new BlameChunk((FileRevision)r2, (int)lineNum, (int)lineNum)).orElseGet(() -> new BlameChunk(new SyntheticBlameInfo(rev, rev, path), (int)lineNum, (int)lineNum, 1));
                    this.currentRev = revision;
                    chunks.add(this.currentChunk);
                }
            }
        };
        if (this.supportedBlameMergeInfo.get()) {
            try {
                client.blame(pathURL, (Revision)endRev, (Revision)new Revision.Number(0L), (Revision)endRev, true, true, callback);
            }
            catch (RepositoryClientException e2) {
                if (e2.getCause() instanceof ClientException && ((ClientException)e2.getCause()).getAprError() == 200007) {
                    Logs.APP_LOG.warn((Object)("No merge info found when calculating file blame. Please upgrade SVN repository " + this.repositoryInfo.getRepositoryURL() + " to the latest supported version (" + HelpUtil.getFishEyeHelpPath("fisheye.supported.platforms") + ")" + " and restart Fisheye repository '" + this.repositoryInfo.getName() + "'"), (Throwable)e2);
                    this.supportedBlameMergeInfo.set(false);
                    client.blame(pathURL, (Revision)endRev, (Revision)new Revision.Number(0L), (Revision)endRev, true, false, callback);
                }
                throw e2;
            }
        } else {
            client.blame(pathURL, (Revision)endRev, (Revision)new Revision.Number(0L), (Revision)endRev, true, false, callback);
        }
        timer.end("chunks=" + chunks.size());
        return chunks;
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.SVN;
    }

    @Override
    public List<String> getSimilarChangeSetIds(String id) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public List<String> findSimilarPartialChangeSetIds(String partialId) throws DbException {
        return Collections.emptyList();
    }

    @Override
    public String getImpliedBranch(Path physicalPath) {
        return this.repositoryInfo.getPathMatcher().getBranch(physicalPath);
    }

    @Override
    public DirInfo findDirInfo(Path lpath) throws DbException {
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        String containerId = pathMatcher.getContainerId(lpath);
        if (containerId.startsWith("tag:")) {
            int taggedRevid = this.fileRevDAO.getRevId(lpath, -1L);
            RevInfoKey key = null;
            if (taggedRevid != -1) {
                key = this.getKey(taggedRevid);
            }
            if (key == null) {
                return null;
            }
            return super.findDirInfo(key.getPath());
        }
        return super.findDirInfo(lpath);
    }

    @Override
    public AndQuery3 findRevisionsUnderDirQuery3(Path dir, boolean findLogical) {
        Path logicalPath;
        if (findLogical && (logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(dir)) != null) {
            return Svn2Cache.findRevisionsUnderLogicalDir3(logicalPath);
        }
        return CommonQuery3Helper.findRevisionsUnderDirAndQuery3(dir, this.isCaseSensitive());
    }

    @Override
    public AndQuery3 findRevisionsUnderDirAndBranchQuery3(Path dir, String branch, boolean findLogical) {
        Path logicalPath;
        if (findLogical && (logicalPath = this.repositoryInfo.getPathMatcher().getLogicalPath(dir)) != null) {
            return Svn2Cache.findRevisionsUnderLogicalDir3(logicalPath);
        }
        return CommonQuery3Helper.findRevisionsUnderDirAndBranchAndQuery3(dir, branch, this.isCaseSensitive());
    }

    public static AndQuery3 findRevisionsUnderLogicalDir3(Path dir) {
        AndQuery3 query = new AndQuery3();
        String dirpath = dir == null ? "" : dir.getPath();
        query.addClause(new TermLookupQuery3(SvnSchema.E_LOGICAL_PATHS, SvnSchema.I_LOGICALPARENTPATHS_TO_REVID, dirpath, null));
        return query;
    }

    @Override
    protected boolean isLogicalPathsSupported() {
        return true;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.repositoryInfo.isCaseSensitive();
    }

    @Override
    public SvnChangeSet getChangeSet(String csid) throws DbException {
        return (SvnChangeSet)this.csDAO.load(csid);
    }

    private int getLastestRevId(Path physicalPath) throws DbException {
        long csid = this.fileRevDAO.getLatestPathChange(physicalPath);
        return this.fileRevDAO.getRevId(physicalPath, csid);
    }

    public void setLatestRevision(long latestRevision) {
        this.latestRevision = latestRevision;
    }

    public long getLatestRevision() {
        return this.latestRevision;
    }

    public long getLatestIndexedCsid() {
        return this.getChangeSetDAO().getLastCsid();
    }

    @Override
    protected Set<Integer> getRevisionIds(Path path, boolean isLogicalPath) throws DbException {
        if (isLogicalPath) {
            return this.fileRevDAO.getRevidsForLogicalPath(path);
        }
        return super.getRevisionIds(path, isLogicalPath);
    }

    @Override
    protected List<Integer> orderRevisions(Iterable<Integer> headRevIds) throws DbException {
        return this.getCommonRevInfoDAO().orderRevisions(headRevIds, false);
    }

    public Set<Path> getPhysicalPathsAtBranch(String branch, Path logicalPath) throws DbException {
        TreeMultimap<Long, Integer> csIdsToRevIds = this.fileRevDAO.getLogicalPathRevisions(logicalPath);
        SegmentedIntSet revids = new SegmentedIntSet();
        for (Integer i2 : csIdsToRevIds.values()) {
            if (revids.get(i2) || !this.fileRevDAO.getBranch(i2).equals(branch)) continue;
            revids.set(i2);
        }
        SortedIntSet pathIdIntSet = this.fileRevDAO.getPhysicalPaths(revids);
        HashSet<Path> paths = new HashSet<Path>();
        int pathId = pathIdIntSet.nextSetBit(0);
        while (pathId >= 0) {
            paths.add(this.fileRevDAO.getPath(pathId));
            pathId = pathIdIntSet.nextSetBit(pathId + 1);
        }
        return paths;
    }

    public Path getPhysicalPathAtTag(Path logicalPath, String tag, int changesetLimit, SvnLogicalPathMatcher matcher) throws DbException {
        int revId = this.fileRevDAO.getTaggedPathRevid(logicalPath, tag, changesetLimit);
        if (revId == -1) {
            return null;
        }
        RevInfoKey rk = this.fileRevDAO.getKey(revId);
        while (!logicalPath.isRoot() && rk != null && !tag.equals(matcher.getTag(rk.getPath()))) {
            revId = this.fileRevDAO.getTaggedPathRevid(logicalPath = logicalPath.trimLast(), tag, changesetLimit);
            if (revId == -1) {
                return null;
            }
            rk = this.fileRevDAO.getKey(revId);
        }
        if (rk != null && tag.equals(matcher.getTag(rk.getPath()))) {
            return rk.getPath();
        }
        return null;
    }

    @Override
    public Optional<Blame> getBlame(RevInfoKey revInfoKey, boolean withScmFallback) throws DbException, IOException {
        String csidString = revInfoKey.getRev();
        SvnChangeSet changeSet = (SvnChangeSet)this.getChangeSetDAO().getChangeSet(csidString);
        if (changeSet != null && changeSet.getIndexingState() == ChangeSetIndexingState.COMPLETE) {
            return super.getBlame(revInfoKey, withScmFallback);
        }
        if (withScmFallback) {
            return Optional.of(this.getBlameFallback(revInfoKey));
        }
        return Optional.empty();
    }

    @Override
    public FileRevision getHeadRevisionOnBranchAtPath(String branchName, Path logicalPath) {
        Set<Path> physicalPaths = this.getPhysicalPathsAtBranch(branchName, logicalPath);
        Path physicalPath = !physicalPaths.isEmpty() ? physicalPaths.iterator().next() : logicalPath;
        return super.getHeadRevisionOnBranchAtPath(branchName, physicalPath);
    }

    @Override
    protected List<Path> findPathRoots(Path suffix, EggTimer timer) throws IOException, DbException {
        return SuffixSearchUtil.findPathRoots(this.getInfDb(), this.getCommonRevInfoDAO(), suffix, this.isCaseSensitive(), timer);
    }
}

