/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.svn;

import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.db.SvnChangeSetDAO;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.util.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Svn2AncestryProcessor {
    private final Svn2RepositoryEngine engine;
    private final boolean upgrade;

    public Svn2AncestryProcessor(Svn2RepositoryEngine engine, boolean upgrade) {
        this.engine = engine;
        this.upgrade = upgrade;
    }

    public void process(final SvnChangeSet changeset) {
        final SvnLogicalPathMatcher pathMatcher = this.engine.getPathMatcher();
        final Svn2Cache cache = (Svn2Cache)this.engine.getInternalRevisionCache();
        final SvnChangeSetDAO changeSetDAO = cache.getChangeSetDAO();
        final SvnRevInfoDAO fileRevisionDAO = cache.getFileRevisionDAO();
        if (FishEyeSysProps.SVN_ANCESTRY_PROCESSING.calculateNoAncestry()) {
            return;
        }
        if (!FishEyeSysProps.SVN_ANCESTRY_PROCESSING.calculateBranchAndTagRootAncestry()) {
            return;
        }
        final HashMap rootSrcBranches = new HashMap();
        final HashSet branchChanges = new HashSet();
        changeset.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                RevInfoKey copySource;
                Path path = revision.getPath();
                SvnRevInfo svnRev = (SvnRevInfo)revision;
                if (pathMatcher.isPhysicalRoot(path) && (copySource = Svn2AncestryProcessor.this.getCopySource(svnRev)) != null) {
                    rootSrcBranches.put(path, Svn2AncestryProcessor.this.getSourceBranch(pathMatcher, copySource.getPath()));
                }
                String effectiveBranch = pathMatcher.getEffectiveBranch(path);
                Path rootPath = pathMatcher.getPhysicalRoot(path);
                branchChanges.add(Pair.newInstance(rootPath, effectiveBranch));
            }
        });
        final HashMap<Pair, Long> rootParentMap = new HashMap<Pair, Long>();
        final HashMap tagParentMap = new HashMap();
        final long previousRev = changeSetDAO.getPreviousCsid(changeset.getLongId());
        for (Pair branchChange : branchChanges) {
            SvnChangeSet latest = (SvnChangeSet)changeSetDAO.getLatestChangesetOnBranchUpTo((String)branchChange.getSecond(), Long.toString(previousRev), true);
            if (latest == null) continue;
            rootParentMap.put(branchChange, latest.getLongId());
        }
        if (this.upgrade) {
            changeset.setBranches(Collections.emptyList());
        }
        final AtomicInteger revisionCount = new AtomicInteger(0);
        changeset.visitRevisions(new Visitor<FileRevision>(){

            @Override
            public void visit(FileRevision revision) {
                block19: {
                    String branch;
                    Path root;
                    Path path;
                    block17: {
                        SvnChangeSet branchLatest;
                        String srcBranch;
                        block18: {
                            SvnChangeSet tagChangeset;
                            SvnRevInfo revInfo = (SvnRevInfo)revision;
                            revisionCount.incrementAndGet();
                            RevInfoKey copySource = Svn2AncestryProcessor.this.getCopySource(revInfo);
                            path = revInfo.getPath();
                            root = pathMatcher.getPhysicalRoot(path);
                            branch = pathMatcher.getEffectiveBranch(revInfo.getPath());
                            if (Svn2AncestryProcessor.this.upgrade) {
                                Svn2AncestryProcessor.this.addBranch(changeset, branch);
                            }
                            if (copySource == null) break block17;
                            long copySourceRevision = Long.parseLong(copySource.getRev());
                            if (!changeSetDAO.isIndexed(copySourceRevision)) {
                                copySourceRevision = changeSetDAO.getPreviousCsid(copySourceRevision);
                            }
                            srcBranch = Svn2AncestryProcessor.this.getSourceBranch(pathMatcher, copySource.getPath());
                            if (rootSrcBranches.containsKey(root) && !srcBranch.equals(rootSrcBranches.get(root))) {
                                return;
                            }
                            if (srcBranch.equals("root:")) {
                                long latest = Svn2AncestryProcessor.getLatestDirChangeUpto(cache, copySource.getPath(), copySourceRevision);
                                branchLatest = latest != -1L ? (SvnChangeSet)changeSetDAO.load(Long.toString(latest)) : null;
                            } else {
                                SvnChangeSet latest;
                                if (pathMatcher.isTagRoot(path) && (latest = (SvnChangeSet)changeSetDAO.getLatestChangesetOnBranchUpTo(branch, Long.toString(previousRev), true)) != null) {
                                    Svn2AncestryProcessor.this.updateBranchRootParentMapLatest(rootParentMap, root, srcBranch, latest);
                                }
                                branchLatest = (SvnChangeSet)changeSetDAO.getLatestChangesetOnBranchUpTo(srcBranch, Long.toString(copySourceRevision), true);
                            }
                            if (branchLatest != null || !pathMatcher.isTag(copySource.getPath())) break block18;
                            long tagLatest = fileRevisionDAO.getLatestPathChangeUpto(copySource.getPath(), copySourceRevision, true);
                            if (tagLatest == -1L) {
                                Path tagRoot = pathMatcher.getTagRoot(copySource.getPath());
                                tagLatest = fileRevisionDAO.getLatestPathChangeUpto(tagRoot, copySourceRevision, false);
                            }
                            if ((tagChangeset = (SvnChangeSet)changeSetDAO.getChangeSet(Long.toString(tagLatest))) == null) break block19;
                            List<String> tagParents = tagChangeset.getTagParents();
                            String tag = pathMatcher.getTag(copySource.getPath());
                            for (String tagParentId : tagParents) {
                                SvnChangeSet tagParent = (SvnChangeSet)changeSetDAO.getChangeSet(tagParentId);
                                if (!tagParent.getTags().contains(tag)) continue;
                                if (pathMatcher.isTag(path)) {
                                    Svn2AncestryProcessor.this.updateTagParentMapLatest(tagParentMap, root, tagParent);
                                    continue;
                                }
                                Svn2AncestryProcessor.this.updateBranchRootParentMapLatest(rootParentMap, root, srcBranch, tagParent);
                            }
                            break block19;
                        }
                        if (pathMatcher.isTag(path)) {
                            Svn2AncestryProcessor.this.updateTagParentMapLatest(tagParentMap, root, branchLatest);
                        } else {
                            Svn2AncestryProcessor.this.updateBranchRootParentMapLatest(rootParentMap, root, srcBranch, branchLatest);
                        }
                        break block19;
                    }
                    SvnChangeSet latest = (SvnChangeSet)changeSetDAO.getLatestChangesetOnBranchUpTo(branch, Long.toString(previousRev), true);
                    if (latest != null) {
                        Svn2AncestryProcessor.this.updateBranchRootParentMapLatest(rootParentMap, root, branch, latest);
                    } else if (pathMatcher.isTag(path)) {
                        SvnChangeSet tagChangeset;
                        long tagLatest = fileRevisionDAO.getLatestPathChangeUpto(path, previousRev, true);
                        if (tagLatest == -1L) {
                            Path tagRoot = pathMatcher.getTagRoot(path);
                            tagLatest = fileRevisionDAO.getLatestPathChangeUpto(tagRoot, previousRev, false);
                        }
                        if ((tagChangeset = (SvnChangeSet)changeSetDAO.getChangeSet(Long.toString(tagLatest))) != null) {
                            List<String> tagParents = tagChangeset.getTagParents();
                            String tag = pathMatcher.getTag(path);
                            for (String tagParentId : tagParents) {
                                SvnChangeSet tagParent = (SvnChangeSet)changeSetDAO.getChangeSet(tagParentId);
                                if (!tagParent.getTags().contains(tag)) continue;
                                Svn2AncestryProcessor.this.updateBranchRootParentMapLatest(rootParentMap, root, branch, tagParent);
                            }
                        }
                    }
                }
            }
        });
        if (revisionCount.get() != 0) {
            HashSet<String> parentIds = new HashSet<String>();
            Iterables.addAll(parentIds, (Iterable)Iterables.transform(rootParentMap.values(), (Function)new Function<Long, String>(){

                public String apply(Long input) {
                    return input.toString();
                }
            }));
            HashSet<String> tagParentIds = new HashSet<String>();
            Iterables.addAll(tagParentIds, (Iterable)Iterables.transform(tagParentMap.values(), (Function)new Function<Long, String>(){

                public String apply(Long input) {
                    return input.toString();
                }
            }));
            changeset.setTagParents(tagParentIds);
            if (!parentIds.isEmpty()) {
                changeset.setParents(parentIds);
            } else if (!tagParentIds.isEmpty()) {
                changeset.setParents(tagParentIds);
            }
            for (Map.Entry entry : tagParentMap.entrySet()) {
                Path tagRoot = (Path)entry.getKey();
                String tag = pathMatcher.getTag(tagRoot);
                String taggedChangesetId = Long.toString((Long)entry.getValue());
                Tag oldTag = changeSetDAO.getTag(tag);
                if (oldTag != null) {
                    Logs.APP_LOG.debug((Object)String.format("Removing old tag %s on changeset %s", oldTag.getName(), oldTag.getChangesetId()));
                    changeSetDAO.removeTag(oldTag);
                }
                Logs.APP_LOG.debug((Object)String.format("Adding tag %s on changeset %s", tag, taggedChangesetId));
                changeSetDAO.addTag(new Tag(tag, taggedChangesetId));
            }
        } else {
            SvnChangeSet previousRootChangeset;
            long previousCsid = changeSetDAO.getPreviousCsid(changeset.getLongId());
            if (previousCsid != -1L && (previousRootChangeset = (SvnChangeSet)changeSetDAO.getLatestChangesetOnBranchUpTo("root:", Long.toString(previousCsid), true)) != null) {
                changeset.setParents(Collections.singletonList(previousRootChangeset.getId()));
            }
        }
    }

    private void addBranch(SvnChangeSet changeset, String branch) {
        if (!changeset.getBranches().contains(branch)) {
            HashSet<String> branches = new HashSet<String>();
            branches.addAll(changeset.getBranches());
            branches.add(branch);
            if (branches.contains("")) {
                branches.remove("");
            }
            changeset.setBranches(branches);
        }
    }

    private RevInfoKey getCopySource(final SvnRevInfo svnRev) {
        Path copySourcePath = svnRev.getCopySourcePath();
        AncestorLink link = svnRev.getAncestorLink();
        if (copySourcePath != null) {
            return new RevInfoKey(copySourcePath, Long.toString(svnRev.getCopySourceRevision()));
        }
        if (this.upgrade) {
            SvnLogicalPathMatcher pathMatcher = this.engine.getPathMatcher();
            Svn2Cache cache = (Svn2Cache)this.engine.getInternalRevisionCache();
            if (link != null && (link.isMove() || link.isCopy())) {
                return svnRev.getAncestors().get(0);
            }
            if (link != null && link.isBranchPoint() && !pathMatcher.isTag(svnRev.getPath())) {
                return svnRev.getAncestors().get(0);
            }
            if (pathMatcher.isTagRoot(svnRev.getPath())) {
                final AtomicReference copySourceRef = new AtomicReference();
                cache.visitRevisionsForTag(pathMatcher.getTag(svnRev.getPath()), new Visitor<FileRevision>(){

                    @Override
                    public void visit(FileRevision revision) {
                        SvnRevInfo taggedRev = (SvnRevInfo)revision;
                        if (taggedRev.getSvnRevision() < svnRev.getSvnRevision()) {
                            if (copySourceRef.get() == null) {
                                copySourceRef.set(taggedRev.getRevInfoKey());
                            } else {
                                long current = Long.parseLong(((RevInfoKey)copySourceRef.get()).getRev());
                                if (current < taggedRev.getSvnRevision()) {
                                    copySourceRef.set(taggedRev.getRevInfoKey());
                                }
                            }
                        }
                    }
                });
                return (RevInfoKey)copySourceRef.get();
            }
        }
        return null;
    }

    protected static long getLatestDirChangeUptoRec(Svn2Cache cache, Path path, long revision) {
        Path[] dirs;
        Path[] files;
        long latest = -1L;
        for (Path file : files = cache.listFiles(path)) {
            long csid = cache.getFileRevisionDAO().getLatestPathChangeUpto(file, revision, false);
            if (csid <= latest) continue;
            latest = csid;
        }
        for (Path dir : dirs = cache.listDirs(path)) {
            long csid;
            if (dir.equals(path) || (csid = Svn2AncestryProcessor.getLatestDirChangeUptoRec(cache, dir, revision)) <= latest) continue;
            latest = csid;
        }
        return latest;
    }

    protected static long getLatestDirChangeUpto(Svn2Cache cache, Path root, long revision) {
        Stack<Path> stack = new Stack<Path>();
        HashSet<Path> visited = new HashSet<Path>();
        stack.push(root);
        visited.add(root);
        long latest = -1L;
        while (!stack.isEmpty()) {
            Path[] dirs;
            Path[] files;
            Path parentPath = (Path)stack.pop();
            for (Path file : files = cache.listFiles(parentPath)) {
                long csid = cache.getFileRevisionDAO().getLatestPathChangeUpto(file, revision, false);
                if (csid <= latest) continue;
                latest = csid;
            }
            for (Path dir : dirs = cache.listDirs(parentPath)) {
                if (visited.add(dir)) {
                    stack.add(dir);
                    continue;
                }
                Logs.APP_LOG.warn((Object)String.format("FE-4697 Revisiting dir: %s from: %s when traversing root dir: %s", dir.getPath(), parentPath.getPath(), root.getPath()));
            }
        }
        return latest;
    }

    private String getSourceBranch(SvnLogicalPathMatcher pathMatcher, Path path) {
        if (pathMatcher.isTagRoot(path)) {
            return pathMatcher.getContainerId(path);
        }
        return pathMatcher.getEffectiveBranch(path);
    }

    private void updateTagParentMapLatest(Map<Path, Long> parentIds, Path root, SvnChangeSet branchLatest) {
        if (branchLatest != null) {
            long branchLatestCsid = branchLatest.getLongId();
            if (!parentIds.containsKey(root) || parentIds.get(root) < branchLatestCsid) {
                parentIds.put(root, branchLatestCsid);
            }
        }
    }

    private void updateBranchRootParentMapLatest(Map<Pair<Path, String>, Long> parentIds, Path root, String branch, SvnChangeSet branchLatest) {
        if (branchLatest != null) {
            long branchLatestCsid = branchLatest.getLongId();
            Pair<Path, String> key = Pair.newInstance(root, branch);
            if (!parentIds.containsKey(key) || parentIds.get(key) < branchLatestCsid) {
                parentIds.put(key, branchLatestCsid);
            }
        }
    }
}

