/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.tags;

import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.atlassian.fisheye.spi.services.RevisionDataService;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.fisheye.stars.tags.StarData;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.vis.ChartLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class StarWebUtil {
    private static final int STARS_IN_DROP_DOWN = 15;

    private static StarData getStarData(StarKey key) {
        TxTemplate txTemplate = SpringContext.getComponent(TxTemplate.class, "txTemplate");
        if (txTemplate.getEffectiveUserLogin() != null) {
            Star star;
            StarManager starManager = SpringContext.getComponent(StarManager.class, "starManager");
            try {
                star = starManager.getStar(key, txTemplate.getEffectiveUserLogin());
            }
            catch (Exception e2) {
                Logs.logWarningWithDetailToDebug("Failed to retrieve star data", e2);
                return null;
            }
            return star == null ? new StarData(key) : new StarData(star);
        }
        return null;
    }

    public static StarData makeStarData(String itemType, String stringKey1, String stringKey2, String stringKey3, String stringKey4, String stringKey5, Integer intKey1, Integer intKey2, Integer intKey3, Integer intKey4, Integer intKey5, String textKey1, String textKey2) {
        return new StarData(-1, itemType, StarWebUtil.replaceEmptyWithNull(stringKey1), StarWebUtil.replaceEmptyWithNull(stringKey2), StarWebUtil.replaceEmptyWithNull(stringKey3), StarWebUtil.replaceEmptyWithNull(stringKey4), StarWebUtil.replaceEmptyWithNull(stringKey5), StarWebUtil.replaceZerowithNull(intKey1), StarWebUtil.replaceZerowithNull(intKey2), StarWebUtil.replaceZerowithNull(intKey3), StarWebUtil.replaceZerowithNull(intKey4), StarWebUtil.replaceZerowithNull(intKey5), StarWebUtil.replaceEmptyWithNull(textKey1), StarWebUtil.replaceEmptyWithNull(textKey2), "", "", "");
    }

    public static StarData getStarData(String itemType, String stringKey1, String stringKey2, String stringKey3, String stringKey4, String stringKey5, Integer intKey1, Integer intKey2, Integer intKey3, Integer intKey4, Integer intKey5, String textKey1, String textKey2) {
        return StarWebUtil.getStarData(new StarKey(itemType, StarWebUtil.replaceEmptyWithNull(stringKey1), StarWebUtil.replaceEmptyWithNull(stringKey2), StarWebUtil.replaceEmptyWithNull(stringKey3), StarWebUtil.replaceEmptyWithNull(stringKey4), StarWebUtil.replaceEmptyWithNull(stringKey5), StarWebUtil.replaceZerowithNull(intKey1), StarWebUtil.replaceZerowithNull(intKey2), StarWebUtil.replaceZerowithNull(intKey3), StarWebUtil.replaceZerowithNull(intKey4), StarWebUtil.replaceZerowithNull(intKey5), StarWebUtil.replaceEmptyWithNull(textKey1), StarWebUtil.replaceEmptyWithNull(textKey2)));
    }

    private static String replaceEmptyWithNull(String s2) {
        return s2.length() == 0 ? null : s2;
    }

    private static Integer replaceZerowithNull(Integer i2) {
        return i2 == 0 ? null : i2;
    }

    public static ChangesetDataFE changeSetForChangesetStarKey(String source, String csid) {
        RevisionDataService revisionDataService = SpringContext.getComponent(RevisionDataService.class, "revisionDataService");
        return revisionDataService.getChangeset(source, csid);
    }

    public static boolean isPathRepoOnly(String path) {
        return path.indexOf(47) == -1;
    }

    public static boolean isPathDir(String repoName, Path path, HttpServletRequest request) throws SourceException {
        EffectiveUserProvider effectiveUserProvider;
        SourceFactory sourceFactory = SpringContext.getComponentByClass(SourceFactory.class);
        Source source = sourceFactory.getSource(repoName, (effectiveUserProvider = (EffectiveUserProvider)SpringContext.getComponent(EffectiveUserProviderImpl.class, "effectiveUserProvider")).getEffectivePrincipal());
        return source.isAvailable() && source.isDir(path.trimFirst());
    }

    public static List<StarData> getLoggedInUsersStars(UserLogin user) {
        StarManager starManager = SpringContext.getComponent(StarManager.class, "starManager");
        ArrayList<StarData> starData = new ArrayList<StarData>();
        if (user != null) {
            for (Star s2 : starManager.getStarsForUser(user.getUserName())) {
                starData.add(new StarData(s2));
            }
        }
        Collections.reverse(starData);
        return starData;
    }

    public static List<StarData> getLoggedInUsersTopStars(UserLogin user) {
        List<StarData> stars = StarWebUtil.getLoggedInUsersStars(user);
        return stars.subList(0, Math.min(15, stars.size()));
    }

    public static ChartLocation getChartStarImageDimension(String type) {
        return ChartLocation.valueOf(type);
    }
}

