/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.tags;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.Map;

public class StarData
extends StarKey {
    private final Integer id;
    private final String label;
    private String link;
    private String name;

    public StarData(Integer id, String itemType, String stringKey1, String stringKey2, String stringKey3, String stringKey4, String stringKey5, Integer intKey1, Integer intKey2, Integer intKey3, Integer intKey4, Integer intKey5, String textKey1, String textKey2, String label, String link, String name) {
        super(itemType, stringKey1, stringKey2, stringKey3, stringKey4, stringKey5, intKey1, intKey2, intKey3, intKey4, intKey5, textKey1, textKey2);
        this.id = id;
        this.label = label;
        this.name = name;
        this.link = link;
    }

    public StarData(Star star) {
        super(star.getItemType(), star.getStringKey1(), star.getStringKey2(), star.getStringKey3(), star.getStringKey4(), star.getStringKey5(), star.getIntKey1(), star.getIntKey2(), star.getIntKey3(), star.getIntKey4(), star.getIntKey5(), star.getTextKey1(), star.getTextKey2());
        this.id = star.getId();
        this.label = star.getLabel();
        this.name = star.getName();
        this.link = star.getLink();
    }

    public StarData(StarKey star) {
        super(star.getItemType(), star.getStringKey1(), star.getStringKey2(), star.getStringKey3(), star.getStringKey4(), star.getStringKey5(), star.getIntKey1(), star.getIntKey2(), star.getIntKey3(), star.getIntKey4(), star.getIntKey5(), star.getTextKey1(), star.getTextKey2());
        this.id = null;
        this.label = null;
        this.link = null;
        this.name = null;
    }

    public boolean isOn() {
        return this.id != null;
    }

    public Integer getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLink() {
        return this.link;
    }

    public String getName() {
        return this.name;
    }

    public String getAsAssocArray() {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (Map.Entry<String, Object> e2 : this.asMap().entrySet()) {
            sb.append(sep);
            this.appendName(sb, e2.getKey());
            if (e2.getValue() instanceof Integer) {
                this.appendInt(sb, (Integer)e2.getValue());
            } else {
                this.appendString(sb, (String)e2.getValue());
            }
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toString() {
        return "StarData{id=" + this.id + ", label=" + this.label + "} " + super.toString();
    }

    public String getAsString() {
        return this.toString();
    }

    public StarType getType() {
        return StarType.getById(this.getItemType());
    }

    private void appendString(StringBuilder sb, String value) {
        sb.append("'").append(ExpressionUtil.escapeJavaScriptString(value)).append("'");
    }

    private void appendInt(StringBuilder sb, Integer value) {
        sb.append(value.toString());
    }

    private void appendName(StringBuilder sb, String name) {
        sb.append("'").append(name).append("': ");
    }
}

