/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.fisheye.stars.model.UserStar;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserStarFactory
extends StarFactory<UserStar> {
    private UserManager userManager;

    public UserStarFactory() {
        super(StarType.USER.getName(), "Users");
    }

    @Autowired
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    protected UserStar makeStar(StarKey key, String userName) throws StarInvalidKeyException {
        return new UserStar(key, userName);
    }

    @Override
    protected void validate(UserStar star, UserLogin user) throws StarInvalidException {
        try {
            if (!this.userManager.existsLicensedUser(star.getFEUsername())) {
                throw new StarInvalidException("User with login " + star.getFEUsername() + " does not exist.", star, user.getUserName());
            }
        }
        catch (DbException e2) {
            throw new StarInvalidException("User with login " + star.getFEUsername() + " cannot currently be accessed.", star, user.getUserName(), e2);
        }
    }
}

