/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.BaseStarModel;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.user.DefaultUserManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class UserStar
extends BaseStarModel {
    public static UserStar forUser(String userName) throws StarInvalidKeyException {
        StarKey userStarKey = new StarKey(StarType.USER.getName());
        userStarKey.setStringKey1(userName);
        return new UserStar(userStarKey, userName);
    }

    public UserStar(StarKey starKey, String userName) throws StarInvalidKeyException {
        super(UserStar.normalizeUsername(starKey), userName);
        this.assertSet(starKey, this.getStringKey1());
    }

    private static StarKey normalizeUsername(StarKey starKey) {
        starKey.setStringKey1(UserManager.USERNAME_NORMALIZATION.apply(starKey.getStringKey1()));
        return starKey;
    }

    protected UserStar() {
    }

    public String getFEUsername() {
        return this.getStringKey1();
    }

    @Override
    public String getLink() {
        return "user/" + FishEyeURLEncoder.uriEncode(this.getFEUsername());
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            name = DefaultUserManager.getDisplayNameForUser(this.getFEUsername());
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        try {
            if (AppConfig.getsConfig().getUserManager().existsLicensedUser(this.getFEUsername())) {
                targetExists = true;
            }
        }
        catch (RuntimeException e2) {
            this.warnDbException(this.getFEUsername());
        }
        return targetExists;
    }
}

