/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.user.UserLogin;

public abstract class StarFactory<T extends Star> {
    private final String type;
    private final String typeDisplayName;

    protected StarFactory(String type, String typeDisplayName) {
        this.type = type;
        this.typeDisplayName = typeDisplayName;
    }

    public String getType() {
        return this.type;
    }

    public T create(UserLogin user, StarKey key) throws StarInvalidException, StarInvalidKeyException {
        T s2 = this.makeStar(key, user.getUserName());
        this.validate(s2, user);
        return s2;
    }

    protected abstract T makeStar(StarKey var1, String var2) throws StarInvalidKeyException;

    protected abstract void validate(T var1, UserLogin var2) throws StarInvalidException;

    public String getTypeDisplayName() {
        return this.typeDisplayName;
    }

    public void validateKey(StarKey key) throws StarInvalidKeyException {
        this.makeStar(key, "dummy");
    }
}

