/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class RevisionStar
extends BaseRepositoryItemStar {
    public RevisionStar() {
    }

    public RevisionStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getStringKey1(), this.getStringKey2(), this.getStringKey3());
    }

    public String getPath() {
        return this.getStringKey1();
    }

    public String getRevision() {
        return this.getStringKey2();
    }

    @Override
    public String getRepName() {
        return this.getStringKey3();
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        path.append("browse/").append(FishEyeURLEncoder.uriEncode(this.getRepName())).append("/").append(FishEyeURLEncoder.pathEncode(this.getPath()));
        path.append("?r=").append(FishEyeURLEncoder.uriEncode(this.getRevision()));
        return path.toString();
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(this.getRevision()).append(" of ").append(this.getPath());
            name = nameBuilder.toString();
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        if (super.targetExists()) {
            try {
                RevInfoKey key = new RevInfoKey(new Path(this.getPath()), this.getRevision());
                try {
                    if (this.getRepHandle().acquireEngine().getRevisionCache().getFileRevision(key) != null) {
                        targetExists = true;
                    }
                }
                catch (DbException e2) {
                    this.warnDbException(this.getPath(), this.getRevision(), this.getRepName());
                }
            }
            catch (RepositoryHandle.StateException e3) {
                this.warnStateChange(this.getPath(), this.getRevision(), this.getRepName());
            }
        }
        return targetExists;
    }
}

