/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.ReviewStar;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.user.UserLogin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReviewStarFactory
extends StarFactory<ReviewStar> {
    private final ReviewManager reviewManager;

    @Autowired
    public ReviewStarFactory(ReviewManager reviewManager) {
        super(StarType.REVIEW.getName(), "Reviews");
        this.reviewManager = reviewManager;
    }

    @Override
    protected ReviewStar makeStar(StarKey key, String userName) throws StarInvalidKeyException {
        return new ReviewStar(key, userName);
    }

    @Override
    protected void validate(ReviewStar star, UserLogin user) throws StarInvalidException {
        Review r2 = this.reviewManager.getReviewById(star.getReviewId());
        if (r2 == null) {
            throw new StarInvalidException("Review " + star.getReviewId() + " does not exist.", star, user.getUserName());
        }
        if (!ReviewUtil.principalCanDoReviewAction((Principal)user, null, UserActionManager.ACTION_VIEW, r2)) {
            throw new StarInvalidException("Review " + star.getReviewId() + " is not visible to " + user.getUserName(), star, user.getUserName());
        }
    }
}

