/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseStarModel;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.tags.MaybeReview;
import com.cenqua.crucible.tags.ReviewUtil;
import com.google.common.base.Strings;

public class ReviewStar
extends BaseStarModel {
    public ReviewStar() {
    }

    public ReviewStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, key.getIntKey1());
    }

    public int getReviewId() {
        return this.getIntKey1();
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        MaybeReview review = ReviewUtil.getSecuredReviewById(this.getReviewId());
        path.append("cru/").append(review.getPermaId());
        return path.toString();
    }

    @Override
    public String getName() {
        MaybeReview review = ReviewUtil.getSecuredReviewById(this.getReviewId());
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            name = review.getPermaId();
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        return DefaultReviewManager.get().getReviewById(this.getReviewId()) != null;
    }
}

