/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.BaseRepositoryItemStarFactory;
import com.atlassian.fisheye.stars.model.QuickSearchStar;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuickSearchStarFactory
extends BaseRepositoryItemStarFactory<QuickSearchStar> {
    @Autowired
    protected QuickSearchStarFactory(UserManager userManager, RepositoryManager repositoryManager) {
        super(userManager, repositoryManager, StarType.QUICKSEARCH.getName(), "Quicksearches");
    }

    @Override
    protected QuickSearchStar makeStar(StarKey key, String userName) throws StarInvalidKeyException {
        return new QuickSearchStar(key, userName);
    }

    @Override
    protected void validate(QuickSearchStar star, UserLogin user) throws StarInvalidException {
        if (!star.isAllRepos()) {
            this.validateRepository(star, user);
        }
        if (Strings.isNullOrEmpty((String)star.getSearchText())) {
            throw new StarInvalidException("Empty search text on a quick search is invalid.", star, user.getUserName());
        }
    }
}

