/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class QuickSearchStar
extends BaseRepositoryItemStar {
    public static final String ALL_REPOS = "__ALL_REPOS__";

    public QuickSearchStar() {
    }

    public QuickSearchStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getStringKey1(), this.getStringKey2());
    }

    public String getSearchText() {
        return this.getStringKey2();
    }

    @Override
    public String getRepName() {
        return this.getStringKey1();
    }

    public boolean isAllRepos() {
        return this.getRepName().equals(ALL_REPOS);
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        if (this.isAllRepos()) {
            path.append("qsearch");
        } else {
            path.append("qsearch/").append(FishEyeURLEncoder.uriEncode(this.getRepName()));
        }
        path.append("?q=").append(FishEyeURLEncoder.uriEncode(this.getSearchText()));
        return path.toString();
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            name = "Quicksearch for '" + this.getSearchText() + "'";
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        return this.isAllRepos() || super.targetExists();
    }
}

