/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.ProjectStar;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.fisheye.user.UserLogin;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ProjectStarFactory
extends StarFactory<ProjectStar> {
    @Resource
    private ProjectManager projectManager;
    @Resource
    private PermissionManager permissionManager;

    protected ProjectStarFactory() {
        super(StarType.PROJECT.getName(), "Projects");
    }

    @Override
    protected ProjectStar makeStar(StarKey key, String userName) throws StarInvalidKeyException {
        return new ProjectStar(key, userName);
    }

    @Override
    protected void validate(ProjectStar star, UserLogin user) throws StarInvalidException {
        Project project = this.projectManager.getProjectById(star.getProjectID());
        if (project == null) {
            throw new StarInvalidException("The project with id " + star.getProjectID() + "does not exist.", star, user.getUserName());
        }
        if (!this.permissionManager.isProjectVisible(project)) {
            throw new StarInvalidException("The project with id " + star.getProjectID() + "is invalid.", star, user.getUserName());
        }
    }
}

