/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseStarModel;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class ProjectStar
extends BaseStarModel {
    public ProjectStar() {
    }

    public ProjectStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getIntKey1());
    }

    public int getProjectID() {
        return this.getIntKey1();
    }

    @Override
    public String getLink() {
        Project project = ProjectUtil.getProjectById(this.getProjectID());
        StringBuilder path = new StringBuilder();
        path.append("cru/browse/").append(FishEyeURLEncoder.uriEncode(project.getProjKey()));
        return path.toString();
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            Project project = ProjectUtil.getProjectById(this.getProjectID());
            name = project != null ? project.getName() : "";
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        return ProjectUtil.getProjectById(this.getProjectID()) != null;
    }
}

