/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class FileStar
extends BaseRepositoryItemStar {
    public FileStar() {
    }

    public FileStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getStringKey1(), this.getStringKey2());
    }

    public String getPath() {
        return this.getStringKey1();
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        path.append("browse/").append(FishEyeURLEncoder.pathEncode(this.getRepoAndPath()));
        return path.toString();
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            name = this.getPath();
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        if (super.targetExists()) {
            try {
                if (this.getRepHandle().acquireEngine().getRevisionCache().getLatestFileRevision(new Path(this.getPath())) != null) {
                    targetExists = true;
                }
            }
            catch (DbException e2) {
                this.warnDbException(this.getPath(), this.getRepName());
            }
            catch (RepositoryHandle.StateException e3) {
                this.warnStateChange(this.getPath(), this.getRepName());
            }
        }
        return targetExists;
    }

    @Override
    public String getRepName() {
        return this.getStringKey2();
    }

    public String getRepoAndPath() {
        return this.getRepName() + "/" + this.getPath();
    }
}

