/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class DiffStar
extends BaseRepositoryItemStar {
    public DiffStar() {
    }

    public DiffStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getStringKey1(), this.getStringKey2(), this.getStringKey3(), this.getStringKey4(), this.getStringKey5());
    }

    public String getFromPath() {
        return this.getStringKey1();
    }

    public String getToPath() {
        return this.getStringKey3();
    }

    public String getFromRevision() {
        return this.getStringKey2();
    }

    public String getToRevision() {
        return this.getStringKey4();
    }

    @Override
    public String getRepName() {
        return this.getStringKey5();
    }

    @Override
    public String getLink() {
        return "browse/" + FishEyeURLEncoder.uriEncode(this.getRepName()) + "/" + FishEyeURLEncoder.pathEncode(this.getFromPath()) + "?r1=" + FishEyeURLEncoder.pathEncode(this.getFromRevision()) + "&r2=" + FishEyeURLEncoder.uriEncode(this.getToRevision());
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            StringBuilder nameBuilder = new StringBuilder();
            if (this.getFromPath().equals(this.getToPath())) {
                nameBuilder.append(this.getFromPath()).append(this.getFromRevision()).append(" - ").append(this.getToRevision());
            } else {
                nameBuilder.append(this.getFromPath()).append(this.getFromRevision()).append(" - ").append(this.getToPath()).append(this.getToRevision());
            }
            name = nameBuilder.toString();
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        if (super.targetExists()) {
            RevInfoKey to = new RevInfoKey(new Path(this.getToPath()), this.getToRevision());
            RevInfoKey from = new RevInfoKey(new Path(this.getFromPath()), this.getFromRevision());
            try {
                RevisionCache<? extends ChangeSet> cache = this.getRepHandle().acquireEngine().getRevisionCache();
                if (cache.getFileRevision(to) != null && cache.getFileRevision(from) != null) {
                    targetExists = true;
                }
            }
            catch (RepositoryHandle.StateException e2) {
                this.warnStateChange(this.getFromPath(), this.getFromRevision(), this.getToPath(), this.getToRevision(), this.getRepName());
            }
            catch (DbException e3) {
                this.warnDbException(this.getFromPath(), this.getFromRevision(), this.getToPath(), this.getToRevision(), this.getRepName());
            }
        }
        return targetExists;
    }
}

