/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.BaseRepositoryItemStarFactory;
import com.atlassian.fisheye.stars.model.CommitterStar;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommitterStarFactory
extends BaseRepositoryItemStarFactory<CommitterStar> {
    @Autowired
    protected CommitterStarFactory(UserManager userManager, RepositoryManager repositoryManager) {
        super(userManager, repositoryManager, StarType.COMMITTER.getName(), "Committers");
    }

    @Override
    protected CommitterStar makeStar(StarKey key, String userName) throws StarInvalidKeyException {
        return new CommitterStar(key, userName);
    }

    @Override
    protected void validate(CommitterStar star, UserLogin user) throws StarInvalidException {
        this.validateRepository(star, user);
        RepositoryHandle repository = this.getRepositoryManager().getRepository(star.getRepName());
        try {
            if (!RepositoryUtil.getCommittersInRep(repository).contains(star.getCommitterName())) {
                throw new StarInvalidException("CommitterDisplayDetails " + star.getCommitterName() + " does not exist in repository " + star.getRepName() + ".", star, user.getUserName());
            }
        }
        catch (DbException e2) {
            throw new StarInvalidException("Problems accessing the repository " + star.getRepName(), star, user.getUserName());
        }
    }
}

