/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.base.Strings;

public class CommitterStar
extends BaseRepositoryItemStar {
    public CommitterStar(StarKey starKey, String userName) throws StarInvalidKeyException {
        super(starKey, userName);
        this.assertSet(starKey, this.getStringKey1(), this.getStringKey2());
    }

    public CommitterStar() {
    }

    @Override
    public String getRepName() {
        return this.getStringKey1();
    }

    public String getCommitterName() {
        return this.getStringKey2();
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        path.append("committer/").append(FishEyeURLEncoder.uriEncode(this.getRepName()));
        path.append("/").append(FishEyeURLEncoder.uriEncode(this.getCommitterName()));
        return path.toString();
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            name = this.getCommitterName() + " in " + this.getRepName();
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        if (super.targetExists()) {
            try {
                if (RepositoryUtil.getCommittersInRep(this.getRepHandle()).contains(this.getCommitterName())) {
                    targetExists = true;
                }
            }
            catch (DbException e2) {
                this.warnDbException(this.getRepName(), this.getCommitterName());
            }
        }
        return targetExists;
    }
}

