/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.CommentStar;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.user.UserLogin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentStarFactory
extends StarFactory<CommentStar> {
    private final CommentManager commentManager;

    @Autowired
    public CommentStarFactory(CommentManager commentManager) {
        super(StarType.COMMENT.getName(), "Comments");
        this.commentManager = commentManager;
    }

    @Override
    protected CommentStar makeStar(StarKey key, String userName) throws StarInvalidKeyException {
        return new CommentStar(key, userName);
    }

    @Override
    protected void validate(CommentStar star, UserLogin user) throws StarInvalidException {
        Comment comment = this.commentManager.getById(star.getCommentID());
        if (comment == null) {
            throw new StarInvalidException("The comment " + star.getCommentID() + " does not exist.", star, user.getUserName());
        }
        if (!ReviewUtil.principalCanDoReviewAction((Principal)user, null, UserActionManager.ACTION_VIEW, comment.getReview())) {
            throw new StarInvalidException("Comment " + star.getCommentID() + " is not visible to " + user.getUserName(), star, user.getUserName());
        }
    }
}

