/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseStarModel;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.google.common.base.Strings;

public class CommentStar
extends BaseStarModel {
    public CommentStar() {
    }

    public CommentStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getIntKey1());
    }

    public int getCommentID() {
        return this.getIntKey1();
    }

    @Override
    public String getLink() {
        Comment comment = DefaultCommentManager.getInstance().getById(this.getCommentID());
        StringBuilder path = new StringBuilder();
        if (comment != null) {
            Review review = comment.getReview();
            path.append("cru/").append(review.getPermaId()).append("/#c").append(this.getCommentID());
        }
        return path.toString();
    }

    @Override
    public String getName() {
        String name = this.getLabel();
        if (Strings.isNullOrEmpty((String)name)) {
            Comment comment = DefaultCommentManager.getInstance().getById(this.getCommentID());
            name = comment != null ? comment.getReview().getPermaId() + '#' + Integer.toString(comment.getId()) : "";
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        return DefaultCommentManager.getInstance().getById(this.getCommentID()) != null;
    }
}

