/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.WaybackSpecChart;
import com.google.common.base.Strings;

public class ChartStar
extends BaseRepositoryItemStar {
    public ChartStar() {
    }

    public ChartStar(StarKey starKey, String userName) throws StarInvalidKeyException {
        super(starKey, userName);
        this.assertSet(starKey, this.getStringKey1(), this.getStringKey2(), this.getStringKey3());
    }

    public String assembleChartParams() {
        return this.getWayBackSpecChartKey() + "/" + this.getRepName() + this.getLocalPath();
    }

    public String getWayBackSpecChartKey() {
        return this.getStringKey3();
    }

    @Override
    public String getRepName() {
        return this.getStringKey2();
    }

    private String getLocalPath() {
        return this.getStringKey1();
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        path.append("chart/").append(this.assembleChartParams());
        return path.toString();
    }

    @Override
    public String getName() {
        if (!Strings.isNullOrEmpty((String)this.getLabel())) {
            return this.getLabel();
        }
        CommandString commands = new CommandString(this.getCommandString());
        WaybackSpecChart wbc = WaybackSpecChart.fromCommandString(commands);
        StringBuilder builder = new StringBuilder();
        if (wbc != null && wbc.getChartType() != null) {
            builder.append(wbc.getChartType());
        } else {
            builder.append("chart ");
        }
        if (wbc != null && wbc.getBreakdownOption() != null) {
            builder.append(" by ").append(wbc.getBreakdownOption().getParamString());
        }
        builder.append(" for ").append(this.getRepName()).append(this.getLocalPath());
        return builder.toString();
    }

    private String getCommandString() {
        return this.getStringKey3().substring("~".length());
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        if (super.targetExists()) {
            try {
                Path path = new Path(this.getLocalPath());
                RevisionCache<? extends ChangeSet> cache = this.getRepHandle().acquireEngine().getRevisionCache();
                if (path.isRoot() || cache.isDir(path) && cache.findDirInfo(path) != null || cache.getLatestFileRevision(path) != null) {
                    targetExists = true;
                }
            }
            catch (DbException e2) {
                this.warnDbException(this.getLocalPath(), this.getRepName(), this.getWayBackSpecChartKey());
            }
            catch (RepositoryHandle.StateException e3) {
                this.warnStateChange(this.getLocalPath(), this.getRepName(), this.getWayBackSpecChartKey());
            }
        }
        return targetExists;
    }
}

