/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.google.common.base.Strings;

public class ChangesetStar
extends BaseRepositoryItemStar {
    public ChangesetStar() {
    }

    public ChangesetStar(StarKey key, String userName) throws StarInvalidKeyException {
        super(key, userName);
        this.assertSet(key, this.getRepName(), this.getCsid());
    }

    @Override
    public String getRepName() {
        return this.getStringKey1();
    }

    public String getCsid() {
        return this.getStringKey2();
    }

    @Override
    public String getLink() {
        StringBuilder path = new StringBuilder();
        path.append("changelog/").append(FishEyeURLEncoder.uriEncode(this.getRepName()));
        path.append("?cs=").append(FishEyeURLEncoder.uriEncode(this.getCsid()));
        return path.toString();
    }

    @Override
    public String getName() {
        String name;
        if (!Strings.isNullOrEmpty((String)this.getLabel())) {
            name = this.getLabel();
        } else {
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(this.getCsid()).append(" in ").append(this.getRepName());
            name = nameBuilder.toString();
        }
        return name;
    }

    @Override
    public boolean targetExists() {
        boolean targetExists = false;
        if (super.targetExists()) {
            try {
                if (this.getRepHandle().acquireEngine().getRevisionCache().getChangeSet(this.getCsid()) != null) {
                    targetExists = true;
                }
            }
            catch (DbException e2) {
                this.warnDbException(this.getRepName(), this.getCsid());
            }
            catch (RepositoryHandle.StateException e3) {
                this.warnStateChange(this.getRepName(), this.getCsid());
            }
        }
        return targetExists;
    }
}

