/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserManager;
import java.util.Date;

public abstract class BaseStarModel
extends StarKey
implements Star {
    private Integer id;
    private String userName;
    private Long dateUpdated;
    private String label;

    protected BaseStarModel() {
    }

    public BaseStarModel(StarKey starKey, String userName) {
        super(starKey);
        this.userName = UserManager.USERNAME_NORMALIZATION.apply(userName);
        this.dateUpdated = System.currentTimeMillis();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.dateUpdated = System.currentTimeMillis();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Date getDateUpdated() {
        return this.dateUpdated == null ? null : new Date(this.dateUpdated);
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated.getTime();
    }

    public Long getDateTimeUpdated() {
        return this.dateUpdated;
    }

    public void setDateTimeUpdated(Long dateTimeUpdated) {
        this.dateUpdated = dateTimeUpdated;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof BaseStarModel)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        BaseStarModel that = (BaseStarModel)o2;
        if (this.dateUpdated != null ? !this.dateUpdated.equals(that.dateUpdated) : that.dateUpdated != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.dateUpdated != null ? this.dateUpdated.hashCode() : 0);
        return result;
    }

    protected void assertSet(StarKey key, Object ... vs) throws StarInvalidKeyException {
        for (Object v2 : vs) {
            if (v2 != null) continue;
            throw new StarInvalidKeyException("The star instance of class " + this.getClass().getName() + " and key " + key.toString() + " doesn't have the correct fields set.");
        }
    }

    protected void warnStateChange(Object ... keys) {
        Logs.APP_LOG.warn((Object)("Star validation for user " + this.getUserName() + " error due to repository not running - not displaying star of type " + this.getItemType() + " with starkey " + this.constructKeyString(keys)));
    }

    private String constructKeyString(Object ... keys) {
        StringBuilder keyString = new StringBuilder();
        for (Object key : keys) {
            keyString.append(key.toString()).append(" ");
        }
        return keyString.toString();
    }

    protected void warnDbException(Object ... keys) {
        Logs.APP_LOG.warn((Object)("Star validation error  user " + this.getUserName() + "  due to database problem - not displaying star of type " + this.getItemType() + " with starkey " + this.constructKeyString(keys)));
    }
}

