/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.model;

import com.atlassian.fisheye.stars.model.BaseRepositoryItemStar;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;

public abstract class BaseRepositoryItemStarFactory<T extends BaseRepositoryItemStar>
extends StarFactory<T> {
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;

    protected BaseRepositoryItemStarFactory(UserManager userManager, RepositoryManager repositoryManager, String type, String typeDisplayName) {
        super(type, typeDisplayName);
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
    }

    protected RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    protected void validateRepository(T star, UserLogin user) throws StarInvalidException {
        RepositoryHandle repository = this.repositoryManager.getRepository(((BaseRepositoryItemStar)star).getRepName());
        if (repository == null) {
            throw new StarInvalidException("The repository " + ((BaseRepositoryItemStar)star).getRepName() + " does not exist.", (StarKey)star, user.getUserName());
        }
        if (!this.userManager.hasPermissionToAccess(user, repository)) {
            throw new StarInvalidException("The repository " + ((BaseRepositoryItemStar)star).getRepName() + " is invalid.", (StarKey)star, user.getUserName());
        }
    }
}

