/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars.action;

import com.atlassian.crucible.actions.AjaxResponse;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.transaction.TransactionStatus;

public abstract class BaseStarAction<T>
extends ActionSupport
implements AjaxResponse,
ServletRequestAware {
    private String errorMessage;
    @Resource
    private TxTemplate txTemplate;
    @Resource
    private StarManager starManager;
    private T result;
    private HttpServletRequest request;

    protected StarManager getStarManager() {
        return this.starManager;
    }

    public String execute() {
        final UserLogin user = this.txTemplate.getEffectiveUserLogin();
        if (user == null) {
            this.errorMessage = this.getClass().getName() + " called with no logged in user";
            return "error";
        }
        try {
            this.txTemplate.execute(new TxCallback<Void>(){

                @Override
                public Void doInTransaction(TransactionStatus status) throws Exception {
                    BaseStarAction.this.result = BaseStarAction.this.executeWithUser(user);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"Problem", (Throwable)e2);
            this.errorMessage = e2.getMessage();
            return "error";
        }
        return "success";
    }

    protected abstract T executeWithUser(UserLogin var1) throws StarInvalidException, StarInvalidKeyException;

    public T getResult() {
        return this.result;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMessage;
    }

    @Override
    public boolean isWorked() {
        return this.errorMessage == null;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }
}

