/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars;

import java.util.HashMap;
import java.util.Map;

public enum StarType {
    CHANGESET("atlassian-changeset", true),
    CHART("atlassian-chart", true),
    COMMENT("atlassian-comment", true),
    COMMITTER("atlassian-committer", false),
    DIFF("atlassian-diff", true),
    DIRECTORY("atlassian-directory", false),
    FILE("atlassian-file", true),
    PROJECT("atlassian-project", true),
    QUICKSEARCH("atlassian-quicksearch", true),
    REPOSITORY("atlassian-repository", true),
    REVIEW("atlassian-review", true),
    REVISION("atlassian-revision", true),
    SEARCH("atlassian-search", true),
    USER("atlassian-user", false);

    private static final Map<String, StarType> map;
    private final String id;
    private final boolean showDialog;

    private StarType(String id, boolean showDialog) {
        this.id = id;
        this.showDialog = showDialog;
    }

    public String getName() {
        return this.id;
    }

    public static StarType getById(String id) {
        return map.get(id);
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    static {
        map = new HashMap<String, StarType>(StarType.values().length);
        for (StarType type : StarType.values()) {
            map.put(type.getName(), type);
        }
    }
}

