/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.stars;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.event.UserRenamedEvent;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.events.StarAddedEvent;
import com.atlassian.fisheye.stars.events.StarDeletedEvent;
import com.atlassian.fisheye.stars.model.BaseStarModel;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarFactory;
import com.atlassian.fisheye.stars.model.StarInvalidException;
import com.atlassian.fisheye.stars.model.StarInvalidKeyException;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.DialectUtils;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="starManager")
@AvailableToPlugins(value=StarManager.class)
public class DefaultStarManager
implements StarManager {
    private Map<String, StarFactory> factories = new HashMap<String, StarFactory>();
    private final EventPublisher eventPublisher;
    private final CurrentSessionProvider currentSessionProvider;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultStarManager(EventPublisher eventPublisher, CurrentSessionProvider currentSessionProvider, TxTemplate txTemplate) {
        this.eventPublisher = eventPublisher;
        this.currentSessionProvider = currentSessionProvider;
        this.txTemplate = txTemplate;
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @Autowired
    public void setStarFactories(StarFactory[] factoryArray) {
        for (StarFactory f2 : factoryArray) {
            this.factories.put(f2.getType(), f2);
        }
    }

    @Override
    public StarFactory getFactory(String type) {
        StarFactory f2 = this.factories.get(type);
        if (f2 == null) {
            throw new RuntimeException("No such star type '" + type + "'");
        }
        return f2;
    }

    @Override
    public Star addStar(StarKey key, UserLogin user) throws StarInvalidException, StarInvalidKeyException {
        Star s2 = this.getStar(key, user);
        if (s2 == null) {
            StarFactory f2 = this.getFactory(key.getItemType());
            s2 = f2.create(user, key);
            this.session().saveOrUpdate((Object)s2);
        }
        this.eventPublisher.publish((Object)new StarAddedEvent(StarType.getById(s2.getItemType())));
        return s2;
    }

    @Override
    public Star getStar(StarKey key, UserLogin user) throws StarInvalidKeyException {
        this.validateKey(key, "In getStar");
        String keyQuery = this.formatKeyQuery(key);
        Query q2 = this.session().createQuery(String.format("from BaseStarModel where %s userName = :userName order by id", keyQuery.length() == 0 ? "" : keyQuery + " and"));
        this.setKeyQueryParams(key, q2);
        q2.setString("userName", UserManager.USERNAME_NORMALIZATION.apply(user.getUserName()));
        List stars = q2.list();
        if (stars.size() > 1) {
            Logs.APP_LOG.error((Object)(stars.size() + " stars returned for key " + key.toString() + " and user " + user.getUserName()));
        }
        return !stars.isEmpty() && ((Star)stars.get(0)).targetExists() ? (Star)stars.get(0) : null;
    }

    private void setKeyQueryParams(StarKey key, Query query) {
        for (Map.Entry<String, Object> e2 : key.asMap().entrySet()) {
            if (e2.getValue() instanceof Integer) {
                query.setInteger(e2.getKey(), ((Integer)e2.getValue()).intValue());
                continue;
            }
            query.setString(e2.getKey(), (String)e2.getValue());
        }
    }

    private String formatKeyQuery(StarKey key) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = key.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            String fieldName = iterator.next();
            if (StarKey.isClobType(fieldName)) {
                sb.append(DialectUtils.getFor(this.session()).getClobsEqualExpression(fieldName, ":" + fieldName));
            } else {
                sb.append(fieldName).append(" = :").append(fieldName);
            }
            if (!iterator.hasNext()) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }

    private BaseStarModel getStarById(int id) {
        Query q2 = this.session().createQuery("from BaseStarModel where id = :id");
        q2.setInteger("id", id);
        return (BaseStarModel)q2.uniqueResult();
    }

    private void validateKey(StarKey key, String message) throws StarInvalidKeyException {
        this.getFactory(key.getItemType()).validateKey(key);
    }

    @Override
    public Star removeStar(int id) {
        BaseStarModel s2 = this.getStarById(id);
        if (s2 != null) {
            StarType type = StarType.getById(s2.getItemType());
            this.session().delete((Object)s2);
            s2.setId(null);
            this.eventPublisher.publish((Object)new StarDeletedEvent(type));
            return s2;
        }
        return null;
    }

    @Override
    public List<Star> getStarsForUser(String username) {
        if (username == null || Principal.Anonymous.ANON.getUserName().equals(username)) {
            return Collections.emptyList();
        }
        Query q2 = this.session().createQuery("from BaseStarModel where userName = :userName");
        q2.setString("userName", UserManager.USERNAME_NORMALIZATION.apply(username));
        return this.filterByExistingStars(q2.list());
    }

    @Override
    public Star setLabel(int id, String label) {
        BaseStarModel star = this.getStarById(id);
        if (star == null) {
            throw new RuntimeException("Couldn't find star with id " + id + " to set label " + label);
        }
        star.setLabel(label);
        return star;
    }

    @Override
    public String getLabel(int id) {
        BaseStarModel star = this.getStarById(id);
        if (star == null) {
            throw new RuntimeException("Couldn't find star with id " + id + " to get label");
        }
        return star.getLabel();
    }

    @Override
    public Star mostRecentlyAddedStar(StarType starType, Principal currentUser) {
        if (starType == null || currentUser == null) {
            throw new IllegalArgumentException("null argument in mostRecentlyAddedStar()");
        }
        if (Principal.Anonymous.isAnon((Principal)currentUser)) {
            throw new IllegalArgumentException("currentUser cannot be anonymous");
        }
        Star star = null;
        Query q2 = this.session().createQuery("from BaseStarModel where userName = :userName and itemType = :starType order by dateTimeUpdated desc");
        q2.setString("userName", UserManager.USERNAME_NORMALIZATION.apply(currentUser.getUserName()));
        q2.setString("starType", starType.getName());
        for (Star s2 : q2.list()) {
            if (!s2.targetExists()) continue;
            star = s2;
            break;
        }
        return star;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    private List<Star> filterByExistingStars(List<Star> stars) {
        ArrayList<Star> existing = new ArrayList<Star>();
        for (Star star : stars) {
            if (!star.targetExists()) continue;
            existing.add(star);
        }
        return existing;
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent userRenamedEvent) {
        this.txTemplate.execute(tx -> {
            String normalizedOldName = UserManager.USERNAME_NORMALIZATION.apply(userRenamedEvent.getOldUsername());
            String normalizedNewName = UserManager.USERNAME_NORMALIZATION.apply(userRenamedEvent.getNewUsername());
            Query q2 = this.session().createQuery("delete BaseStarModel where userName = :newName");
            q2.setString("newName", normalizedNewName);
            int numrows = q2.executeUpdate();
            q2 = this.session().createQuery("update BaseStarModel set userName = :newName where userName = :oldName");
            q2.setString("oldName", normalizedOldName);
            q2.setString("newName", normalizedNewName);
            numrows = q2.executeUpdate();
            q2 = this.session().createQuery("delete BaseStarModel where itemType = :itemType and stringKey1 = :newName");
            q2.setString("itemType", StarType.USER.getName());
            q2.setString("newName", normalizedNewName);
            numrows = q2.executeUpdate();
            q2 = this.session().createQuery("update BaseStarModel set stringKey1 = :newName where itemType = :itemType and stringKey1 = :oldName");
            q2.setString("itemType", StarType.USER.getName());
            q2.setString("oldName", normalizedOldName);
            q2.setString("newName", normalizedNewName);
            numrows = q2.executeUpdate();
            return null;
        });
    }
}

