/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.services;

import com.atlassian.crucible.spi.data.VersionInfo;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.services.ServerInfoService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.SecurityType;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ServerInfoService")
@AvailableToPlugins
public class DefaultServerInfoService
implements ServerInfoService {
    private final TxTemplate txTemplate;
    private final RootConfig rootConfig;

    @Autowired
    public DefaultServerInfoService(RootConfig rootConfig, TxTemplate txTemplate) {
        this.rootConfig = rootConfig;
        this.txTemplate = txTemplate;
    }

    public TimeZone getServerTimeZone() {
        return AppConfig.getsConfig().getTimezone();
    }

    public String getAppHome() {
        this.requirePermission();
        return AppConfig.getAppHome().getPath();
    }

    public String getInstanceDir() {
        this.requirePermission();
        return AppConfig.getInstanceDir().getPath();
    }

    public VersionInfo getProductVersionInfo() {
        return new VersionInfo("4.0.4", "2016-05-06");
    }

    public boolean isFishEye() {
        return AppConfig.isFishEye();
    }

    public boolean isCrucible() {
        return AppConfig.isCrucible();
    }

    public String getProductName() {
        return AppConfig.getProductName();
    }

    private void requirePermission() throws NotPermittedException {
        SecurityType security = this.rootConfig.getConfig().getSecurity();
        if (!security.getAllowAnon() && Principal.Anonymous.ANON.equals((Object)this.txTemplate.getEffectivePrincipal())) {
            throw new NotPermittedException("You must be logged in to access this service, or configure FishEye to allow anonymous access globally.");
        }
    }
}

