/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.services;

import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.atlassian.fisheye.spi.services.RecentChangesetsService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.csindex.SpiRecentChangesSearcher2;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Disposer;
import com.google.common.base.Strings;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultRecentChangesetsService
implements RecentChangesetsService {
    private final RepositoryManager repositoryManager;
    private SPIUtils spiUtils;
    private final SPIUserUtils spiUserUtils;

    @Autowired
    public DefaultRecentChangesetsService(RepositoryManager repositoryManager, SPIUtils spiUtils, SPIUserUtils spiUserUtils) {
        this.repositoryManager = repositoryManager;
        this.spiUtils = spiUtils;
        this.spiUserUtils = spiUserUtils;
    }

    public List<ChangesetDataFE> listChangesets(String repository, RecentChangesetsService.QueryParameters parameters) {
        RepositoryHandle rep = this.getRepository(repository);
        Disposer.pushThreadInstance();
        try {
            RepositoryEngine engine = rep.acquireEngine();
            RecentChangesParams2 params = this.getParameters(parameters, engine);
            SpiRecentChangesSearcher2 searcher = new SpiRecentChangesSearcher2(engine.getRevisionCache(), engine.getCrossRepLuceneConnection(), this.spiUtils);
            List<ChangesetDataFE> list = searcher.findRecentChangeSets(params);
            return list;
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.debug((Object)"Repository state exception", (Throwable)((Object)e2));
            throw new RuntimeException((Throwable)((Object)e2));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private RecentChangesParams2 getParameters(RecentChangesetsService.QueryParameters parameters, RepositoryEngine engine) throws DbException {
        RecentChangesParams2 rcParams = new RecentChangesParams2();
        if (!Strings.isNullOrEmpty((String)parameters.getPath())) {
            rcParams.setBasePath(new Path(parameters.getPath()));
        }
        rcParams.setCompulsoryCommitter(parameters.getCommitter());
        rcParams.setCommentSearchText(parameters.getComment());
        rcParams.setP4JobFixed(parameters.getP4JobFixed());
        if (parameters.getMaxReturn() != null) {
            rcParams.setMaxReturn(parameters.getMaxReturn());
        }
        if (parameters.getMaxCsid() != null) {
            Object cs = engine.getRevisionCache().getChangeSet(parameters.getMaxCsid());
            if (cs == null) {
                throw new IllegalArgumentException("Could not find changeset '" + parameters.getMaxCsid() + "' in repository '" + engine.getName() + "'");
            }
            rcParams.setMaxChangeset((ChangeSet)cs, false);
        }
        return rcParams;
    }

    private RepositoryHandle getRepository(String repository) {
        if (Strings.isNullOrEmpty((String)repository)) {
            throw new IllegalArgumentException("Must supply a repository name");
        }
        this.spiUserUtils.requireUserHasPermissionToAccess(repository);
        RepositoryHandle rep = this.repositoryManager.getRepository(repository);
        if (rep == null) {
            throw new IllegalArgumentException("The repository " + repository + " does not exist");
        }
        return rep;
    }

    public RecentChangesetsService.QueryParameters.Builder getQueryBuilder() {
        return new QueryParametersImpl.BuilderImpl();
    }

    public static class QueryParametersImpl
    implements RecentChangesetsService.QueryParameters {
        private String path;
        private String committer;
        private String comment;
        private String p4JobFixed;
        private Integer maxReturn;
        private String maxCsid;

        private QueryParametersImpl(String path, String committer, String comment, String p4JobFixed, Integer maxReturn, String maxCsid) {
            this.path = path;
            this.committer = committer;
            this.comment = comment;
            this.p4JobFixed = p4JobFixed;
            this.maxReturn = maxReturn;
            this.maxCsid = maxCsid;
        }

        public Integer getMaxReturn() {
            return this.maxReturn;
        }

        public String getPath() {
            return this.path;
        }

        public String getCommitter() {
            return this.committer;
        }

        public String getComment() {
            return this.comment;
        }

        public String getP4JobFixed() {
            return this.p4JobFixed;
        }

        public boolean isPathRecursive() {
            return true;
        }

        public String getMaxCsid() {
            return this.maxCsid;
        }

        public static class BuilderImpl
        implements RecentChangesetsService.QueryParameters.Builder {
            private Integer maxReturn;
            private String path;
            private String committer;
            private String comment;
            private String p4JobFixed;
            private String maxCsid;

            private BuilderImpl() {
            }

            public RecentChangesetsService.QueryParameters build() {
                return new QueryParametersImpl(this.path, this.committer, this.comment, this.p4JobFixed, this.maxReturn, this.maxCsid);
            }

            public RecentChangesetsService.QueryParameters.Builder path(String path) {
                return this.path(path, true);
            }

            public RecentChangesetsService.QueryParameters.Builder path(String path, boolean recursive) {
                this.path = path;
                return this;
            }

            public RecentChangesetsService.QueryParameters.Builder committer(String name) {
                this.committer = name;
                return this;
            }

            public RecentChangesetsService.QueryParameters.Builder comment(String comment) {
                this.comment = comment;
                return this;
            }

            public RecentChangesetsService.QueryParameters.Builder p4JobFixed(String p4JobKey) {
                this.p4JobFixed = p4JobKey;
                return this;
            }

            public RecentChangesetsService.QueryParameters.Builder maxReturn(Integer maxReturn) {
                if (maxReturn != null && maxReturn < 0) {
                    throw new IllegalArgumentException("maxReturn must not be negative (received " + maxReturn + ")");
                }
                this.maxReturn = maxReturn;
                return this;
            }

            public RecentChangesetsService.QueryParameters.Builder beforeCsid(String csid) {
                this.maxCsid = csid;
                return this;
            }
        }
    }
}

