/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.services;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.spi.services.LocMetricsService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultLocMetricsService
implements LocMetricsService {
    @Resource
    private RepositoryManager repositoryManager;

    public Long getRevisionCount(String repository, LocMetricsService.QueryParameters parameters) {
        final AtomicLong revs = new AtomicLong();
        BucketProcessor processor = new BucketProcessor(){

            @Override
            public void processBucket(BucketDataElement bde) {
                revs.addAndGet(bde.getRevcount());
            }
        };
        this.queryBuckets(repository, parameters, processor);
        return revs.get();
    }

    public Long getLocCount(String repository, LocMetricsService.QueryParameters parameters) {
        final AtomicLong loc = new AtomicLong();
        BucketProcessor processor = new BucketProcessor(){

            @Override
            public void processBucket(BucketDataElement bde) {
                loc.addAndGet(bde.getLinecountChange());
            }
        };
        this.queryBuckets(repository, parameters, processor);
        return loc.get();
    }

    public LocMetricsService.QueryParameters.Builder getQueryBuilder() {
        return new QueryParametersImpl.BuilderImpl();
    }

    private void queryBuckets(String repository, LocMetricsService.QueryParameters parameters, BucketProcessor processor) {
        Disposer.pushThreadInstance();
        try {
            RepositoryEngine engine = this.repositoryManager.getRepository(repository).acquireEngine();
            BucketGraph bucketGraph = engine.getBucketGraph();
            BucketDataCollectionTotalled data = bucketGraph.getBuckets(this.asBucketQuery(engine, parameters));
            this.processBucketData(data, processor);
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.debug((Object)"Repository State Exception", (Throwable)((Object)e2));
            throw new RuntimeException((Throwable)((Object)e2));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void processBucketData(BucketDataCollectionTotalled data, BucketProcessor bp) throws DbException {
        try {
            for (BucketDataTotalled bucket : data.getValueList()) {
                for (Map.Entry e2 : bucket.getData().entrySet()) {
                    bp.processBucket((BucketDataElement)e2.getValue());
                }
            }
        }
        catch (BucketGraph.InvalidBucketException e3) {
            Logs.APP_LOG.debug((Object)"Invalid Bucket", (Throwable)e3);
            throw new RuntimeException(e3);
        }
    }

    private ParameterSetQuery asBucketQuery(RepositoryEngine engine, LocMetricsService.QueryParameters parameters) {
        BreakdownOption groupBy = BreakdownOption.NONE;
        if (parameters.isGroupByAuthor()) {
            groupBy = BreakdownOption.AUTHOR;
        } else if (parameters.isGroupByExtension()) {
            groupBy = BreakdownOption.EXTN;
        } else if (parameters.isGroupBySubdirectory()) {
            groupBy = BreakdownOption.SUBDIR;
        }
        Path path = new Path(parameters.getPath());
        String branch = parameters.getBranch();
        if (branch == null && !path.isRoot()) {
            branch = engine.getRevisionCache().getImpliedBranch(path);
        }
        return new ParameterSetQuery(path, branch, parameters.getFileExtensions(), parameters.getCommitters(), groupBy);
    }

    public static class QueryParametersImpl
    implements LocMetricsService.QueryParameters {
        private Date minDate;
        private Date maxDate;
        private Integer dayOfWeek;
        private Integer hourOfDay;
        private Integer dayOfMonth;
        private Boolean groupBySubdirectory;
        private Boolean groupByExtension;
        private Boolean groupByAuthor;
        private List<String> committers;
        private List<String> fileExtensions;
        private String branch;
        private String path;

        private QueryParametersImpl(Date minDate, Date maxDate, Integer hourOfDay, Integer dayOfWeek, Integer dayOfMonth, List<String> committers, String branch, List<String> fileExtensions, String path, Boolean groupBySubdirectory, Boolean groupByExtension, Boolean groupByAuthor) {
            this.minDate = minDate;
            this.maxDate = maxDate;
            this.dayOfWeek = dayOfWeek;
            this.hourOfDay = hourOfDay;
            this.dayOfMonth = dayOfMonth;
            this.groupBySubdirectory = groupBySubdirectory != null && groupBySubdirectory != false;
            this.groupByExtension = groupByExtension != null && groupByExtension != false;
            this.groupByAuthor = groupByAuthor != null && groupByAuthor != false;
            this.committers = this.immutable(committers);
            this.branch = branch;
            this.fileExtensions = this.immutable(fileExtensions);
            this.path = path;
        }

        private List<String> immutable(List<String> argList) {
            return argList == null ? null : Collections.unmodifiableList(new ArrayList<String>(argList));
        }

        public Date getMinDate() {
            return this.minDate;
        }

        public Date getMaxDate() {
            return this.maxDate;
        }

        public Integer getDayOfWeek() {
            return this.dayOfWeek;
        }

        public Integer getHourOfDay() {
            return this.hourOfDay;
        }

        public Integer getDayOfMonth() {
            return this.dayOfMonth;
        }

        public boolean isGroupBySubdirectory() {
            return this.groupBySubdirectory;
        }

        public boolean isGroupByExtension() {
            return this.groupByExtension;
        }

        public boolean isGroupByAuthor() {
            return this.groupByAuthor;
        }

        public List<String> getCommitters() {
            return this.committers;
        }

        public String getBranch() {
            return this.branch;
        }

        public List<String> getFileExtensions() {
            return this.fileExtensions;
        }

        public String getPath() {
            return this.path;
        }

        public static class BuilderImpl
        implements LocMetricsService.QueryParameters.Builder {
            private Date minDate;
            private Date maxDate;
            private Integer dayOfWeek;
            private Integer hourOfDay;
            private Integer dayOfMonth;
            private Boolean groupBySubdirectory;
            private Boolean groupByExtension;
            private Boolean groupByAuthor;
            private List<String> committers;
            private List<String> fileExtensions;
            private String branch;
            private String path;

            private BuilderImpl() {
            }

            public LocMetricsService.QueryParameters build() {
                return new QueryParametersImpl(this.minDate, this.maxDate, this.hourOfDay, this.dayOfWeek, this.dayOfMonth, this.committers, this.branch, this.fileExtensions, this.path, this.groupBySubdirectory, this.groupByExtension, this.groupByAuthor);
            }

            public LocMetricsService.QueryParameters.Builder minDate(Date minDate) {
                this.minDate = minDate;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder maxDate(Date maxDate) {
                this.maxDate = maxDate;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder dayOfWeek(int dayOfWeek) {
                this.dayOfWeek = dayOfWeek;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder hourOfDay(int hourOfDay) {
                this.hourOfDay = hourOfDay;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder dayOfMonth(int dayOfMonth) {
                this.dayOfMonth = dayOfMonth;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder committers(List<String> committers) {
                this.committers = committers;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder branch(String branch) {
                this.branch = branch;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder fileExtensions(List<String> fileExtensions) {
                this.fileExtensions = fileExtensions;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder path(String path) {
                this.path = path;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder groupBySubdirectory() {
                this.checkGroupByUnset();
                this.groupBySubdirectory = true;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder groupByExtension() {
                this.checkGroupByUnset();
                this.groupByExtension = true;
                return this;
            }

            public LocMetricsService.QueryParameters.Builder groupByAuthor() {
                this.checkGroupByUnset();
                this.groupByAuthor = true;
                return this;
            }

            private void checkGroupByUnset() {
                if (this.groupBySubdirectory != null || this.groupByExtension != null || this.groupByAuthor != null) {
                    throw new IllegalArgumentException("Can not set multiple 'groupBy' options (groupBySubdirectory:" + (this.groupBySubdirectory != null) + " groupByExtension:" + (this.groupByExtension != null) + " groupByAuthor:" + (this.groupByAuthor != null));
                }
            }
        }
    }

    private static interface BucketProcessor {
        public void processBucket(BucketDataElement var1) throws BucketGraph.InvalidBucketException;
    }
}

