/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.services;

import com.atlassian.fisheye.spi.services.ChangesetMetricsService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.crossrepo.ChangesetCannedQueries;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Disposer;
import java.util.Date;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultChangesetMetricsService
implements ChangesetMetricsService {
    private CrossRepLuceneIndex crossRepLuceneIndex = AppConfig.getsConfig().getCrossRepLuceneIndex();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getChangesetCount(String repository, ChangesetMetricsService.QueryParameters parameters) {
        ChangesetStatsCalculator calc = this.buildCalculator(repository, parameters);
        Disposer.pushThreadInstance();
        try {
            Long l2 = calc.count(this.getConnection());
            return l2;
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public Map<String, Integer> getCommitVolumeByDay(final String repository, final ChangesetMetricsService.QueryParameters parameters) {
        return this.generateCommitVolumeMap(new ActivityMapGenerator(){

            @Override
            protected Map<String, Integer> generate(LuceneConnection<CrossRepLuceneIndexes> lc) throws DbException {
                return DefaultChangesetMetricsService.this.buildCalculator(repository, parameters).activityByDay(lc);
            }
        });
    }

    public Map<String, Integer> getCommitVolumeByHour(final String repository, final ChangesetMetricsService.QueryParameters parameters) {
        return this.generateCommitVolumeMap(new ActivityMapGenerator(){

            @Override
            protected Map<String, Integer> generate(LuceneConnection<CrossRepLuceneIndexes> lc) throws DbException {
                return DefaultChangesetMetricsService.this.buildCalculator(repository, parameters).activityByHour(lc);
            }
        });
    }

    public Map<String, Integer> getCommitVolumeForLastYearByWeek(final String repository, final ChangesetMetricsService.QueryParameters parameters) {
        return this.generateCommitVolumeMap(new ActivityMapGenerator(){

            @Override
            protected Map<String, Integer> generate(LuceneConnection<CrossRepLuceneIndexes> lc) throws DbException {
                return DefaultChangesetMetricsService.this.buildCalculator(repository, parameters).getCommitVolumeForPastYearByWeek(lc, ChangesetIndexer.getEmptyWeekMapForLastYear());
            }
        });
    }

    private Map<String, Integer> generateCommitVolumeMap(ActivityMapGenerator generator) {
        Disposer.pushThreadInstance();
        try {
            Map<String, Integer> map = generator.generate(this.getConnection());
            return map;
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private ChangesetStatsCalculator buildCalculator(String repository, ChangesetMetricsService.QueryParameters parameters) {
        return new ChangesetStatsCalculator(ChangesetCannedQueries.metricsServiceQuery(repository, parameters));
    }

    public ChangesetMetricsService.QueryParameters.Builder getQueryBuilder() {
        return new QueryParametersImpl.BuilderImpl();
    }

    private LuceneConnection<CrossRepLuceneIndexes> getConnection() {
        return this.crossRepLuceneIndex.getConnection();
    }

    public static class QueryParametersImpl
    implements ChangesetMetricsService.QueryParameters {
        private Date minDate;
        private Date maxDate;
        private Integer dayOfWeek;
        private Integer hourOfDay;
        private Integer dayOfMonth;
        private String committer;
        private String branch;
        private String fileName;
        private String fileExtension;
        private String path;
        private String comment;

        private QueryParametersImpl(Date minDate, Date maxDate, Integer hourOfDay, Integer dayOfWeek, Integer dayOfMonth, String committer, String branch, String fileName, String fileExtension, String path, String comment) {
            this.minDate = minDate;
            this.maxDate = maxDate;
            this.dayOfWeek = dayOfWeek;
            this.hourOfDay = hourOfDay;
            this.dayOfMonth = dayOfMonth;
            this.committer = committer;
            this.branch = branch;
            this.fileName = fileName;
            this.fileExtension = fileExtension;
            this.path = path;
            this.comment = comment;
        }

        public Date getMinDate() {
            return this.minDate;
        }

        public Date getMaxDate() {
            return this.maxDate;
        }

        public Integer getDayOfWeek() {
            return this.dayOfWeek;
        }

        public Integer getHourOfDay() {
            return this.hourOfDay;
        }

        public Integer getDayOfMonth() {
            return this.dayOfMonth;
        }

        public String getCommitter() {
            return this.committer;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public String getPath() {
            return this.path;
        }

        public String getComment() {
            return this.comment;
        }

        public static class BuilderImpl
        implements ChangesetMetricsService.QueryParameters.Builder {
            private Date minDate;
            private Date maxDate;
            private Integer dayOfWeek;
            private Integer hourOfDay;
            private Integer dayOfMonth;
            private String committer;
            private String branch;
            private String fileName;
            private String fileExtension;
            private String path;
            private String comment;

            private BuilderImpl() {
            }

            public ChangesetMetricsService.QueryParameters build() {
                return new QueryParametersImpl(this.minDate, this.maxDate, this.hourOfDay, this.dayOfWeek, this.dayOfMonth, this.committer, this.branch, this.fileName, this.fileExtension, this.path, this.comment);
            }

            public ChangesetMetricsService.QueryParameters.Builder minDate(Date minDate) {
                this.minDate = minDate;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder maxDate(Date maxDate) {
                this.maxDate = maxDate;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder dayOfWeek(int dayOfWeek) {
                this.dayOfWeek = dayOfWeek;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder hourOfDay(int hourOfDay) {
                this.hourOfDay = hourOfDay;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder dayOfMonth(int dayOfMonth) {
                this.dayOfMonth = dayOfMonth;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder committer(String committer) {
                this.committer = committer;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder branch(String branch) {
                this.branch = branch;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder fileExtension(String fileExtension) {
                this.fileExtension = fileExtension;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder path(String path) {
                this.path = path;
                return this;
            }

            public ChangesetMetricsService.QueryParameters.Builder comment(String comment) {
                this.comment = comment;
                return this;
            }
        }
    }

    private abstract class ActivityMapGenerator {
        private ActivityMapGenerator() {
        }

        protected abstract Map<String, Integer> generate(LuceneConnection<CrossRepLuceneIndexes> var1) throws DbException;
    }
}

