/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.rpc;

import com.atlassian.crucible.spi.rpc.LastChange;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fisheye.spi.services.RepositoryService;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class SingleRepoLastChange
implements LastChange {
    private static AtomicLong seq = new AtomicLong(0L);
    private static ConcurrentMap<String, LastChange.LastChangeTag> lastModified = new ConcurrentHashMap<String, LastChange.LastChangeTag>();
    private String repository;
    private RepositoryService repositoryService;

    public SingleRepoLastChange(String repository, RepositoryService repositoryService) {
        this.repository = repository;
        this.repositoryService = repositoryService;
    }

    @Override
    public LastChange.LastChangeTag getLastChange() throws NotFoundException {
        if (!this.repositoryService.exists(this.repository)) {
            return this.newETag(System.currentTimeMillis());
        }
        return this.checkForUpdate();
    }

    public LastChange.LastChangeTag checkForUpdate() {
        LastChange.LastChangeTag repoLastModified = (LastChange.LastChangeTag)lastModified.get(this.repository);
        long newLastModified = this.repositoryService.getLastModified(this.repository);
        if (newLastModified < 0L) {
            throw new NotFoundException("Repository " + this.repository + " not found");
        }
        if (repoLastModified == null || repoLastModified.getDate().getTime() < newLastModified) {
            LastChange.LastChangeTag newTag = this.newETag(newLastModified);
            if (repoLastModified == null) {
                lastModified.putIfAbsent(this.repository, newTag);
            } else {
                lastModified.replace(this.repository, repoLastModified, newTag);
            }
            return newTag;
        }
        return repoLastModified;
    }

    private LastChange.LastChangeTag newETag(long lastModified) {
        return new LastChange.LastChangeTag(new Date(lastModified), String.format("%d-%d", lastModified, seq.incrementAndGet()));
    }
}

