/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.rpc;

import com.atlassian.crucible.spi.rpc.LastChange;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fisheye.spi.services.RepositoryService;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class FeAnyRepoChange
implements LastChange {
    private static AtomicReference<LastChange.LastChangeTag> lastModified = new AtomicReference();
    private static final AtomicLong seq = new AtomicLong();
    private final RepositoryService repositoryService;

    public FeAnyRepoChange(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public LastChange.LastChangeTag getLastChange() throws NotFoundException {
        this.checkForUpdate();
        return lastModified.get();
    }

    public void checkForUpdate() {
        long newLastModified = this.repositoryService.getLastModified();
        LastChange.LastChangeTag oldLastModified = lastModified.get();
        if (oldLastModified == null || oldLastModified.getDate().getTime() < newLastModified) {
            lastModified.compareAndSet(oldLastModified, new LastChange.LastChangeTag(new Date(newLastModified), String.format("%d-%d", newLastModified, seq.getAndIncrement())));
        }
    }
}

