/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.fisheye.spi.data.WatchData;
import com.atlassian.fisheye.spi.services.WatchService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins
@Component(value="watchService")
public class WatchServiceImpl
implements WatchService {
    private static final WatchDataFromWatch WATCH_DATA_FROM_WATCH = new WatchDataFromWatch();
    private final WatchManager watchManager;
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;

    @Autowired
    public WatchServiceImpl(WatchManager watchManager, UserManager userManager, RepositoryManager repositoryManager) {
        this.watchManager = watchManager;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
    }

    public List<WatchData> getWatchesForUser(String userName) {
        this.verifyUser(userName);
        List<Watch> watches = this.watchManager.getWatchesForUser(userName);
        return this.asWatchDataList(watches);
    }

    public List<WatchData> getWatchesForRepo(String repoName) {
        this.verifyRepo(repoName);
        List<Watch> watches = this.watchManager.getWatchesForRep(repoName);
        return this.asWatchDataList(watches);
    }

    public boolean addWatch(WatchData watch) {
        this.verifyUser(watch.getUser());
        this.verifyRepo(watch.getRepository());
        if (this.getWatch(watch) == null) {
            this.watchManager.addWatch(watch.getUser(), watch.getRepository(), new Path(watch.getPath()), this.getWaybackSpec(watch));
            return true;
        }
        return false;
    }

    private void verifyRepo(String repo) {
        Preconditions.checkArgument((this.repositoryManager.getRepository(repo) != null ? 1 : 0) != 0, (String)"Repository %s does not exist.", (Object[])new Object[]{repo});
    }

    private void verifyUser(String user) {
        Preconditions.checkArgument((boolean)this.userManager.existsLicensedUser(user), (String)"User %s does not exist.", (Object[])new Object[]{user});
    }

    public boolean removeWatch(WatchData watch) {
        Watch exisiting = this.getWatch(watch);
        if (exisiting != null) {
            this.watchManager.deleteWatch(exisiting.getId());
            return true;
        }
        return false;
    }

    private Watch getWatch(WatchData watch) {
        Path path = new Path(watch.getPath());
        WaybackSpec waybackSpec = this.getWaybackSpec(watch);
        return this.watchManager.getWatch(watch.getUser(), watch.getRepository(), path, waybackSpec);
    }

    private WaybackSpec getWaybackSpec(WatchData watch) {
        return watch.getConstraint() == null ? null : WaybackSpec.fromCommandString(new CommandString(watch.getConstraint()));
    }

    private List<WatchData> asWatchDataList(List<Watch> watches) {
        return ImmutableList.copyOf((Collection)Lists.transform(watches, (Function)WATCH_DATA_FROM_WATCH));
    }

    private static class WatchDataFromWatch
    implements Function<Watch, WatchData> {
        private WatchDataFromWatch() {
        }

        public WatchData apply(Watch watch) {
            WaybackSpec constraint = watch.getConstraint();
            String constraintString = null;
            if (constraint != null && !constraint.isEmpty()) {
                constraintString = constraint.toCommandString().toString();
            }
            return new WatchData(watch.getRep(), watch.getPath().getPath(), watch.getUser().getUsername(), constraintString);
        }
    }
}

