/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.fisheye.spi.data.CvsRepositoryData;
import com.atlassian.fisheye.spi.data.GitRepositoryData;
import com.atlassian.fisheye.spi.data.HgRepositoryData;
import com.atlassian.fisheye.spi.data.P4RepositoryData;
import com.atlassian.fisheye.spi.data.RepositoryDataFE;
import com.atlassian.fisheye.spi.data.SvnRepositoryData;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.rep.RepositoryHandle;

public class RepositoryDataFactory {
    public RepositoryDataFE fromHandle(RepositoryHandle repositoryHandle) {
        ScmType repositoryType = repositoryHandle.getCfg().getRepositoryType();
        switch (repositoryType) {
            case CVS: {
                CvsRepositoryData cvsRepositoryData = new CvsRepositoryData();
                this.applyCommonAttributes(repositoryHandle, (RepositoryDataFE)cvsRepositoryData);
                this.applyCvsAttributes(repositoryHandle, cvsRepositoryData);
                return cvsRepositoryData;
            }
            case SVN: {
                SvnRepositoryData repositoryData = new SvnRepositoryData();
                this.applyCommonAttributes(repositoryHandle, (RepositoryDataFE)repositoryData);
                this.applySvnAttributes(repositoryHandle, repositoryData);
                return repositoryData;
            }
            case P4: {
                P4RepositoryData p4RepositoryData = new P4RepositoryData();
                this.applyCommonAttributes(repositoryHandle, (RepositoryDataFE)p4RepositoryData);
                this.applyPerforceAttributes(repositoryHandle, p4RepositoryData);
                return p4RepositoryData;
            }
            case GIT: {
                GitRepositoryData gitRepositoryData = new GitRepositoryData();
                this.applyCommonAttributes(repositoryHandle, (RepositoryDataFE)gitRepositoryData);
                this.applyGitAttributes(repositoryHandle, gitRepositoryData);
                return gitRepositoryData;
            }
            case CLEARCASE: {
                RepositoryDataFE defaultResponse = new RepositoryDataFE();
                this.applyCommonAttributes(repositoryHandle, defaultResponse);
                return defaultResponse;
            }
            case HG: {
                HgRepositoryData hgRepositoryData = new HgRepositoryData();
                this.applyCommonAttributes(repositoryHandle, (RepositoryDataFE)hgRepositoryData);
                this.applyHgAttributes(repositoryHandle, hgRepositoryData);
                return hgRepositoryData;
            }
        }
        throw new IllegalArgumentException("Unknown repository type: " + (Object)((Object)repositoryType));
    }

    private void applyCommonAttributes(RepositoryHandle handle, RepositoryDataFE data) {
        data.setName(handle.getName());
        data.setEnabled(handle.getCfg().isEnabled());
        data.setState(RepositoryDataFE.RepositoryState.getState((String)handle.getStateDescription()));
        data.setFinishedFullSlurp(handle.getStatus().isInitialCrucibleIndexingComplete());
    }

    private void applyCvsAttributes(RepositoryHandle repositoryHandle, CvsRepositoryData cvsRepositoryData) {
        CvsRepType cvs = repositoryHandle.getCfg().getRepositoryTypeConfig().getCvs();
        cvsRepositoryData.setDir(cvs.getDir());
    }

    private void applySvnAttributes(RepositoryHandle repositoryHandle, SvnRepositoryData repositoryData) {
        SvnRepType svn = repositoryHandle.getCfg().getRepositoryTypeConfig().getSvn();
        repositoryData.setPath(svn.getPath());
        repositoryData.setUrl(svn.getUrl());
    }

    private void applyPerforceAttributes(RepositoryHandle repositoryHandle, P4RepositoryData p4RepositoryData) {
        P4RepType p4 = repositoryHandle.getCfg().getRepositoryTypeConfig().getPerforce();
        p4RepositoryData.setPath(p4.getPath());
        p4RepositoryData.setPort(p4.isSetPort() ? Integer.valueOf(p4.getPort().intValue()) : null);
        p4RepositoryData.setServer(p4.getServer());
    }

    private void applyGitAttributes(RepositoryHandle repositoryHandle, GitRepositoryData gitRepositoryData) {
        GitRepType git = repositoryHandle.getCfg().getRepositoryTypeConfig().getGit();
        gitRepositoryData.setLocation(git.getLocation());
        gitRepositoryData.setPath(git.getPath());
    }

    private void applyHgAttributes(RepositoryHandle repositoryHandle, HgRepositoryData hgRepositoryData) {
        HgRepType hg = repositoryHandle.getCfg().getRepositoryTypeConfig().getHg();
        hgRepositoryData.setLocation(hg.getLocation());
    }
}

