/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.tx.TxHelperStylePlatformTransactionManager;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.google.common.base.Throwables;
import org.hibernate.JDBCException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

@Component(value="txTemplate")
@AvailableToPlugins
public class DefaultTxTemplate
implements TxTemplate {
    private final EffectiveUserProviderImpl effectiveUserProvider;
    private final PlatformTransactionManager platformTransactionManager;

    @Autowired
    public DefaultTxTemplate(EffectiveUserProviderImpl effectiveUserProvider) {
        this(new TxHelperStylePlatformTransactionManager(), effectiveUserProvider);
    }

    public DefaultTxTemplate(PlatformTransactionManager platformTransactionManager, EffectiveUserProviderImpl effectiveUserProvider) {
        this.platformTransactionManager = platformTransactionManager;
        this.effectiveUserProvider = effectiveUserProvider;
    }

    @Override
    public void pushEffectivePrincipal(Principal userLogin, FecruUser cuser) {
        this.effectiveUserProvider.pushEffectivePrincipal(userLogin, cuser);
    }

    @Override
    public void popEffectivePrincipal() {
        this.effectiveUserProvider.popEffectivePrincipal();
    }

    @Override
    public void setEffectivePrincipal(Principal userLogin, FecruUser cuser) {
        this.effectiveUserProvider.setEffectivePrincipal(userLogin, cuser);
    }

    @Override
    public Principal getEffectivePrincipal() {
        return this.effectiveUserProvider.getEffectivePrincipal();
    }

    @Override
    public UserLogin getEffectiveUserLogin() {
        return this.effectiveUserProvider.getEffectiveUserLogin();
    }

    @Override
    public boolean isAdmin() {
        return this.effectiveUserProvider.isAdmin();
    }

    @Override
    public FecruUser getEffectiveCrucibleUser() {
        return this.effectiveUserProvider.getEffectiveUser();
    }

    @Override
    public <T> T execute(TxCallback<T> callback) {
        TransactionStatus status = this.platformTransactionManager.getTransaction(null);
        try {
            T t2 = callback.doInTransaction(status);
            return t2;
        }
        catch (JDBCException e2) {
            Logs.APP_LOG.error((Object)("SQL execution error " + e2.getSQLState() + " - " + e2.getSQL()));
            status.setRollbackOnly();
            throw Throwables.propagate((Throwable)e2);
        }
        catch (Exception e3) {
            status.setRollbackOnly();
            throw Throwables.propagate((Throwable)e3);
        }
        finally {
            if (!status.isRollbackOnly()) {
                this.platformTransactionManager.commit(status);
            }
            this.platformTransactionManager.rollback(status);
        }
    }
}

