/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.fisheye.spi.services.IllegalRepositoryStateException;
import com.atlassian.fisheye.spi.services.SvnRepositoryService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.util.Disposer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultSvnRepositoryService
implements SvnRepositoryService {
    private RepositoryManager repositoryManager;

    @Autowired
    public DefaultSvnRepositoryService(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public SvnRepositoryService.BranchDetails getBranchDetails(String repository, String path) {
        RepositoryHandle rep = this.repositoryManager.getRepository(repository);
        Disposer.pushThreadInstance();
        try {
            SvnRepType svnRepType = rep.acquireEngine().getCfg().getRepositoryTypeConfig().getSvn();
            SvnLogicalPathMatcher matcher = new SvnLogicalPathMatcher(svnRepType.getSymbolic());
            String branch = matcher.getBranch(new Path(path));
            if (branch == null) {
                SvnRepositoryService.BranchDetails branchDetails = null;
                return branchDetails;
            }
            FileHistory history = rep.acquireEngine().getRevisionCache().getFileHistory(new Path(path));
            String branchPoint = history.getBranchPoint(branch);
            BranchDetailsImpl branchDetailsImpl = new BranchDetailsImpl(branchPoint, history.getRevision(branchPoint).getBranch());
            return branchDetailsImpl;
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)((Object)e2));
            throw new IllegalRepositoryStateException("Repository " + repository + " is in wrong state: " + rep.getStateDescription(), (Throwable)((Object)e2));
        }
        catch (ConfigException e3) {
            throw new RuntimeException(e3);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public static class BranchDetailsImpl
    implements SvnRepositoryService.BranchDetails {
        private String branchParent;
        private String branchPoint;

        private BranchDetailsImpl(String branchParent, String branchPoint) {
            this.branchParent = branchParent;
            this.branchPoint = branchPoint;
        }

        public String getBranchPoint() {
            return this.branchParent;
        }

        public String getBranchParent() {
            return this.branchPoint;
        }
    }
}

