/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.data.FileRevisionKeyData;
import com.atlassian.fisheye.spi.data.TabularQueryResultData;
import com.atlassian.fisheye.spi.services.SearchService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.util.Disposer;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searchServiceFE")
@AvailableToPlugins
public class DefaultSearchService
implements SearchService {
    private static final int MAX_MAX_RETURN = 3000;
    private final SPIUserUtils spiUserUtils;
    private final SPIUtils spiUtils;
    private final RepositoryManager repositoryManager;
    private final ReviewManager reviewManager;
    private final TxTemplate txTemplate;

    @Autowired
    public DefaultSearchService(SPIUserUtils spiUserUtils, SPIUtils spiUtils, RepositoryManager repositoryManager, ReviewManager reviewManager, TxTemplate txTemplate) {
        this.spiUserUtils = spiUserUtils;
        this.spiUtils = spiUtils;
        this.repositoryManager = repositoryManager;
        this.reviewManager = reviewManager;
        this.txTemplate = txTemplate;
    }

    public List<FileRevisionKeyData> query(String repository, String query, int maxResults) {
        this.spiUserUtils.requireUserHasPermissionToAccess(repository);
        RepositoryHandle rep = this.repositoryManager.getRepository(repository);
        ArrayList<String> errors = new ArrayList<String>();
        FishQuery q2 = FishQuery.parse(query, errors);
        if (q2 == null) {
            if (errors.size() > 0) {
                throw new IllegalArgumentException("Error in query: " + errors);
            }
            return null;
        }
        Disposer.pushThreadInstance();
        try {
            RepositoryEngine eng = rep.acquireEngine();
            SearchManager search = eng.getSearchManager();
            SearchResults collator = search.runQuery(q2, true);
            if (collator.hasTabularResults()) {
                throw new IllegalArgumentException("Query contains a return clause, use queryAsRows");
            }
            ArrayList<FileRevisionKeyData> result = new ArrayList<FileRevisionKeyData>();
            SearchResults.RevisionResultsIterator i2 = collator.iterateRevisions(0);
            int maxReturn = Math.min(maxResults, 3000);
            for (int count = 0; i2.hasNext() && count < maxReturn; ++count) {
                RevInfoKey key = i2.nextItem().getRevInfoKey();
                result.add(new FileRevisionKeyData(key.getPath().getPath(), key.getRev()));
            }
            ArrayList<FileRevisionKeyData> arrayList = result;
            return arrayList;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new RuntimeException("Error accessing repository " + repository, e2);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public List<FileRevisionKeyData> query(String repository, String query) {
        return this.query(repository, query, 3000);
    }

    public TabularQueryResultData queryAsRows(String repository, String query, int maxResults) {
        Disposer.pushThreadInstance();
        try {
            this.spiUserUtils.requireUserHasPermissionToAccess(repository);
            RepositoryHandle rep = this.repositoryManager.getRepository(repository);
            ArrayList<String> errors = new ArrayList<String>();
            FishQuery q2 = FishQuery.parse(query, errors);
            if (q2 == null) {
                if (errors.size() > 0) {
                    throw new IllegalArgumentException("Error in query: " + errors);
                }
                TabularQueryResultData tabularQueryResultData = null;
                return tabularQueryResultData;
            }
            RepositoryEngine eng = rep.acquireEngine();
            SearchManager search = eng.getSearchManager();
            SearchResults collator = search.runQuery(q2, true);
            int maxReturn = Math.min(maxResults, 3000);
            if (collator.hasTabularResults()) {
                TabularQueryResultData tabularQueryResultData = this.createTabularQueryResultData(collator.getReturnClause(), collator.iterateData(0), maxReturn);
                return tabularQueryResultData;
            }
            try {
                throw new IllegalArgumentException("Query does not contain a return clause, use query");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e2) {
                throw new RuntimeException("Error accessing repository " + repository, e2);
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public TabularQueryResultData queryAsRows(String repository, String query) {
        return this.queryAsRows(repository, query, 3000);
    }

    public List<ReviewData> getReviewsForChangeset(String repository, final String csid) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, List<ReviewData>>(){

            public List<ReviewData> apply(RepositoryEngine engine) {
                Object changeSet = engine.getRevisionCache().getChangeSet(csid);
                return DefaultSearchService.this.getReviewsForChangeset(changeSet);
            }
        });
    }

    public Map<String, List<ReviewData>> getReviewsForChangesets(final String repository, final Set<String> changesets) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, Map<String, List<ReviewData>>>(){

            public Map<String, List<ReviewData>> apply(RepositoryEngine engine) {
                LinkedHashMap<String, List<ReviewData>> results = new LinkedHashMap<String, List<ReviewData>>();
                RevisionCache<? extends ChangeSet> revisionCache = engine.getRevisionCache();
                for (String csid : changesets) {
                    Object changeSet = revisionCache.getChangeSet(csid);
                    if (changeSet != null) {
                        List reviewKeys = DefaultSearchService.this.getReviewsForChangeset(changeSet);
                        results.put(csid, reviewKeys);
                        continue;
                    }
                    Logs.APP_LOG.warn((Object)String.format("getReviewsForChangesets() : Changeset '%s' not found in repository '%s'", csid, repository));
                }
                return results;
            }
        });
    }

    private List<ReviewData> getReviewsForChangeset(ChangeSet changeSet) {
        Set<Integer> revIds = changeSet.getReviewIds();
        ArrayList<ReviewData> reviewDatas = new ArrayList<ReviewData>();
        Collection<Review> reviews = this.reviewManager.getReviewsByIds(revIds);
        for (Review review : reviews) {
            if (!ReviewUtil.principalCanDoReviewAction(this.txTemplate.getEffectivePrincipal(), null, UserActionManager.ACTION_VIEW, review)) continue;
            ReviewData.Builder reviewBuilder = new ReviewData.Builder();
            reviewBuilder.setPermaId(review.getPermaId());
            reviewBuilder.setPermaIdHistory(review.getPermaIdHistoryAsStrings());
            reviewBuilder.setState(this.spiUtils.modelStateToDataState(review.getState()));
            reviewBuilder.setDescription(review.getDescription());
            reviewBuilder.setName(review.getName());
            reviewDatas.add(reviewBuilder.build());
        }
        return reviewDatas;
    }

    private TabularQueryResultData createTabularQueryResultData(ReturnClause md, SearchResults.TabularResultsIterator i2, int maxResults) {
        ArrayList types = Lists.newArrayListWithCapacity((int)md.numFields());
        ArrayList names = Lists.newArrayListWithCapacity((int)md.numFields());
        block8: for (int c2 = 0; c2 < md.numFields(); ++c2) {
            ReturnClause.Field f2 = md.getField(c2);
            names.add(f2.getColumnName());
            switch (f2.getType()) {
                case DATE: {
                    types.add(TabularQueryResultData.SearchResultColumnType.DATE);
                    continue block8;
                }
                case INTEGER: {
                    types.add(TabularQueryResultData.SearchResultColumnType.INTEGER);
                    continue block8;
                }
                case STRING_ARRAY: {
                    types.add(TabularQueryResultData.SearchResultColumnType.STRING_LIST);
                    continue block8;
                }
                case MAP_ARRAY: {
                    types.add(TabularQueryResultData.SearchResultColumnType.MAP_LIST);
                    continue block8;
                }
                default: {
                    types.add(TabularQueryResultData.SearchResultColumnType.STRING);
                }
            }
        }
        TabularQueryResultData data = new TabularQueryResultData((List)types, (List)names);
        for (int count = 0; i2.hasNext() && count < maxResults; ++count) {
            try {
                data.addRow(this.getObjectList(i2.nextRow(), md.numFields()));
                continue;
            }
            catch (Exception e2) {
                throw new RuntimeException("Error accessing query data", e2);
            }
        }
        return data;
    }

    private List<Object> getObjectList(SearchResults.ResultRow resultRow, int numColumns) {
        ArrayList objects = Lists.newArrayListWithCapacity((int)numColumns);
        for (int i2 = 0; i2 < numColumns; ++i2) {
            List<Object> o2 = resultRow.get(i2);
            if (o2 instanceof Path) {
                o2 = ((Path)((Object)o2)).getPath();
            } else if (o2 instanceof String[]) {
                o2 = Arrays.asList((String[])o2);
            } else if (o2 instanceof Map[]) {
                o2 = Arrays.asList((Map[])o2);
            }
            objects.add(o2);
        }
        return objects;
    }
}

