/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.fisheye.csvis.VisResult;
import com.atlassian.fisheye.csvis.VisualisationChangesetsCalculator;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.atlassian.fisheye.spi.data.ChangesetsData;
import com.atlassian.fisheye.spi.data.FileRevisionData;
import com.atlassian.fisheye.spi.data.PathInfoData;
import com.atlassian.fisheye.spi.data.RevisionGraphSliceData;
import com.atlassian.fisheye.spi.services.Direction;
import com.atlassian.fisheye.spi.services.RevisionDataService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4ChangeSet;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="revisionDataService")
@AvailableToPlugins
public class DefaultRevisionDataService
implements RevisionDataService {
    private static final int MAX_MAX_RETURN = 3000;
    private final SPIUtils spiUtils;

    @Autowired
    public DefaultRevisionDataService(SPIUtils spiUtils) {
        this.spiUtils = spiUtils;
    }

    public List<PathInfoData> listPaths(final String repository, final String path) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, List<PathInfoData>>(){

            public List<PathInfoData> apply(RepositoryEngine engine) {
                FileHistory history;
                Path dir = new Path(path);
                RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
                if (!cache.isDir(dir)) {
                    throw new NotFoundException("Path \"" + path + "\" is not a directory in repository " + repository);
                }
                Path[] dirs = cache.listDirs(dir);
                Path[] files = cache.listFiles(dir);
                ArrayList<PathInfoData> pathInfo = new ArrayList<PathInfoData>(dirs.length + files.length);
                for (Path dir1 : dirs) {
                    history = cache.getFileHistory(dir1);
                    pathInfo.add(new PathInfoData(dir1.getName(), true, DefaultRevisionDataService.this.isHeadDeleted(history)));
                }
                for (Path child : files) {
                    history = cache.getFileHistory(child);
                    pathInfo.add(new PathInfoData(child.getName(), false, DefaultRevisionDataService.this.isHeadDeleted(history)));
                }
                return pathInfo;
            }
        });
    }

    private boolean isHeadDeleted(FileHistory history) throws DbException {
        if (history == null) {
            return false;
        }
        String head = history.getHead();
        if (head == null) {
            return false;
        }
        FileRevision rev = history.getRevision(head);
        return rev != null && rev.isDead();
    }

    public FileRevisionData getRevision(final String repository, final String path, final String rev) {
        if (rev == null) {
            throw new IllegalArgumentException("Revision parameter must be provided");
        }
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, FileRevisionData>(){

            public FileRevisionData apply(RepositoryEngine engine) {
                RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
                FileRevision fileRevision = DefaultRevisionDataService.this.getFileRevision(cache, path, rev, false);
                return DefaultRevisionDataService.this.spiUtils.createFileRevisionData(fileRevision, repository);
            }
        });
    }

    public List<String> listTagsForRevision(String repository, final String path, final String rev) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, List<String>>(){

            public List<String> apply(RepositoryEngine engine) {
                RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
                FileRevision fileRevision = DefaultRevisionDataService.this.getFileRevision(cache, path, rev, true);
                ArrayList<String> tags = new ArrayList<String>(fileRevision.getTags());
                Collections.sort(tags);
                return tags;
            }
        });
    }

    public List<FileRevisionData> listPathHistory(final String repository, final String path) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, List<FileRevisionData>>(){

            public List<FileRevisionData> apply(RepositoryEngine engine) {
                RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
                FileHistory info = cache.getFileHistory(new Path(path));
                if (info != null) {
                    Collection<FileRevision> origRevs = info.getRevisions();
                    ArrayList<FileRevision> revisions = new ArrayList<FileRevision>(origRevs);
                    Collections.sort(revisions, FileRevision.OLDEST_FIRST_COMPARATOR);
                    Collections.reverse(revisions);
                    ArrayList<FileRevisionData> revs = new ArrayList<FileRevisionData>();
                    for (FileRevision revision : revisions) {
                        revs.add(DefaultRevisionDataService.this.spiUtils.createFileRevisionData(revision, repository));
                    }
                    return revs;
                }
                throw new NotFoundException("path not found: " + path);
            }
        });
    }

    public ChangesetDataFE getChangeset(final String repository, final String csid) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, ChangesetDataFE>(){

            public ChangesetDataFE apply(RepositoryEngine engine) {
                RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
                Object cs = cache.getChangeSet(csid);
                if (cs == null) {
                    throw new NotFoundException("changeset '" + csid + "' not found in repository " + repository);
                }
                return DefaultRevisionDataService.this.spiUtils.createChangesetDataFEFrom((ChangeSet)cs);
            }
        });
    }

    public ChangesetsData listChangesets(String repository, String path) {
        return this.listChangesets(repository, path, null, null, Integer.MAX_VALUE);
    }

    public ChangesetsData listChangesets(String repository, String path, Date start) {
        return this.listChangesets(repository, path, start, null, Integer.MAX_VALUE);
    }

    public ChangesetsData listChangesets(final String repository, final String path, final Date start, final Date end, final int max) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, ChangesetsData>(){

            public ChangesetsData apply(RepositoryEngine engine) {
                List<String> csids;
                Path dir;
                int maxReturn = Math.min(3000, max);
                RecentChangesParams2 params = new RecentChangesParams2();
                RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
                if (!cache.isDir(dir = new Path(path))) {
                    throw new NotFoundException("Path " + path + " is not a directory in repository " + repository);
                }
                params.setBasePath(dir);
                params.setMaxReturn(maxReturn);
                if (start != null) {
                    params.setMinDate(start.getTime());
                }
                if (end != null) {
                    params.setMaxDate(end.getTime());
                }
                return new ChangesetsData(maxReturn == (csids = cache.findRecentChangeSetIds(params)).size(), csids);
            }
        });
    }

    private String getTipRevision(ChangeSetService<? extends ChangeSet> changeSetService, Set<String> branches) {
        ChangeSet cs = changeSetService.getTipChangeSet(branches);
        return cs == null ? null : cs.getId();
    }

    public RevisionGraphSliceData getSliceInRevisionGraph(String repository, String startingRev, int max, Direction direction) {
        return this.getSliceInRevisionGraph(repository, startingRev, Collections.emptySet(), max, direction);
    }

    public RevisionGraphSliceData getSliceInRevisionGraph(String repository, final String startingRevOrEmpty, final Set<String> branches, final int max, final Direction direction) {
        return this.spiUtils.withRepository(repository, new Function<RepositoryEngine, RevisionGraphSliceData>(){

            public RevisionGraphSliceData apply(RepositoryEngine engine) {
                RevisionCache<? extends ChangeSet> changeSetService = engine.getRevisionCache();
                String startingRev = Strings.isNullOrEmpty((String)startingRevOrEmpty) ? DefaultRevisionDataService.this.getTipRevision(changeSetService, branches) : startingRevOrEmpty;
                RevisionGraphSliceData data = new RevisionGraphSliceData();
                if (startingRev != null) {
                    VisualisationChangesetsCalculator calculator = new VisualisationChangesetsCalculator(changeSetService);
                    VisResult slice = calculator.getChangeSets(startingRev, max, branches, direction);
                    for (ChangeSet cs : slice.getLiveChangesets()) {
                        ChangesetDataFE changesetDataForSlice = DefaultRevisionDataService.this.createChangesetDataForSlice(cs);
                        if (changesetDataForSlice == null) continue;
                        data.addRevision(changesetDataForSlice);
                    }
                    for (ChangeSet cs : slice.getAdjacentContextChangesets()) {
                        data.addSparseRevision(DefaultRevisionDataService.this.createChangesetDataForSlice(cs));
                    }
                    for (ChangeSet cs : slice.getSpanningContextChangesets()) {
                        data.addSparseRevision(DefaultRevisionDataService.this.createChangesetDataForSlice(cs));
                    }
                }
                return data;
            }
        });
    }

    private ChangesetDataFE createChangesetDataForSlice(ChangeSet changeSet) {
        if (changeSet == null) {
            Logs.APP_LOG.debug((Object)"Changeset was null in createChangesetDataForSlice - ignoring");
            return null;
        }
        if (changeSet.getPosition() == null) {
            Logs.APP_LOG.debug((Object)("Changeset has not been assigned a position: " + changeSet.getId()));
            return null;
        }
        ChangesetDataFE.ChangesetDataFEBuilder builder = ChangesetDataFE.newBuilder().setRepositoryName(changeSet.getRepName()).setCsid(changeSet.getId()).setDisplayId(changeSet.getDisplayId()).setBranches(changeSet.getBranches()).setTags(changeSet.getTags()).setOrder(changeSet.getPosition().toString()).setParents(new LinkedHashSet<String>(changeSet.getParents())).setChildren(new LinkedHashSet<String>(changeSet.getChildren()));
        if (changeSet instanceof P4ChangeSet) {
            builder.setP4JobIds(changeSet.getFixes());
        }
        return builder.build();
    }

    private FileRevision getFileRevision(RevisionCache cache, String path, String rev, boolean lazy) {
        FileRevision rinfo;
        RevInfoKey rik = new RevInfoKey(new Path(path), rev);
        int revId = cache.getRevId(rik);
        FileRevision fileRevision = rinfo = revId != -1 ? cache.getFileRevision(revId, lazy) : null;
        if (rinfo == null) {
            throw new NotFoundException("file/revision not found: " + rik);
        }
        return rinfo;
    }
}

