/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.spi.data.RepositoryDataFE;
import com.atlassian.fisheye.spi.services.CommitterDataService;
import com.atlassian.fisheye.spi.services.IllegalRepositoryStateException;
import com.atlassian.fisheye.spi.services.RepositoryService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryServiceFE")
@AvailableToPlugins
public class DefaultRepositoryService
implements CommitterDataService,
RepositoryService {
    private final SPIUtils spiUtils;
    private final UserManager userManager;
    private final EffectiveUserProvider effectiveUserProvider;
    private final RepositoryManager repositoryManager;

    @Autowired
    public DefaultRepositoryService(SPIUtils spiUtils, UserManager userManager, EffectiveUserProvider effectiveUserProvider, RepositoryManager repositoryManager) {
        this.spiUtils = spiUtils;
        this.userManager = userManager;
        this.effectiveUserProvider = effectiveUserProvider;
        this.repositoryManager = repositoryManager;
    }

    public List<RepositoryDataFE> listRepositories() {
        List<RepositoryHandle> reps = this.repositoryManager.getHandles();
        ArrayList<RepositoryDataFE> repositories = new ArrayList<RepositoryDataFE>();
        for (RepositoryHandle rep : reps) {
            if (!this.isAccessible(rep) || !this.spiUtils.hasPermissionToAccess(rep)) continue;
            repositories.add(this.spiUtils.createRepositoryDataFEFrom(rep));
        }
        return repositories;
    }

    private boolean isAccessible(RepositoryHandle handle) {
        return this.userManager.hasPermissionToAccess(this.effectiveUserProvider.getEffectivePrincipal(), handle);
    }

    public RepositoryDataFE getRepositoryInfo(String name) {
        this.spiUtils.requireUserHasPermissionToAccess(name);
        RepositoryHandle rep = this.repositoryManager.getRepository(name);
        return this.spiUtils.createRepositoryDataFEFrom(rep);
    }

    public List<String> listCommitters(String repository) {
        return this.listCommitters(repository, Path.ROOT);
    }

    @Override
    public List<String> listCommitters(String repository, final Path path) {
        return this.doInPermittedRepo(repository, new Function<RepositoryEngine, List<String>>(){

            public List<String> apply(RepositoryEngine engine) {
                return engine.getRevisionCache().findAuthors(path);
            }
        });
    }

    @Override
    public int countCommitters(String repository, final Path path) {
        return this.doInPermittedRepo(repository, new Function<RepositoryEngine, Integer>(){
            int count = 0;

            public Integer apply(RepositoryEngine engine) {
                engine.getRevisionCache().visitAuthors(path, new StoppableVisitor<String>(){

                    @Override
                    public boolean visit(String committer) {
                        ++count;
                        return true;
                    }
                });
                return this.count;
            }
        });
    }

    public boolean isFile(String repository, String path) {
        RepositoryHandle rep = this.repositoryManager.getRepository(repository);
        Disposer.pushThreadInstance();
        try {
            boolean bl = rep.acquireEngine().getRevisionCache().isFile(new Path(path));
            return bl;
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)((Object)e2));
            throw new IllegalRepositoryStateException("Repository " + repository + " is in wrong state: " + rep.getStateDescription(), (Throwable)((Object)e2));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public boolean isDirectory(String repository, String path) {
        Disposer.pushThreadInstance();
        RepositoryHandle rep = this.repositoryManager.getRepository(repository);
        try {
            boolean bl = rep.acquireEngine().getRevisionCache().isDir(new Path(path));
            return bl;
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.error((Object)"Exception", (Throwable)((Object)e2));
            throw new IllegalRepositoryStateException("Repository " + repository + " is in wrong state: " + rep.getStateDescription(), (Throwable)((Object)e2));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public List<String> getAvailableFileExtensions(String repository, String path) {
        Disposer.pushThreadInstance();
        try {
            BucketGraph bucketGraph = this.repositoryManager.getRepository(repository).acquireEngine().getBucketGraph();
            List<String> list = bucketGraph.getAvailableExtensions(new Path(path));
            return list;
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.debug((Object)"Repository State Exception", (Throwable)((Object)e2));
            throw new RuntimeException((Throwable)((Object)e2));
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public long getLastModified(String repository) {
        return this.repositoryManager.getLastModified(repository);
    }

    public long getLastModified() {
        return this.repositoryManager.getLastModified();
    }

    public boolean exists(String repository) {
        return this.repositoryManager.getRepository(repository) != null;
    }

    public boolean isRepositoryAccessible(String repository) {
        RepositoryHandle handle = this.repositoryManager.getRepository(repository);
        return handle != null && handle.isRunning() && this.userManager.hasPermissionToAccess(this.effectiveUserProvider.getEffectivePrincipal(), handle);
    }

    private <T> T doInPermittedRepo(String repository, Function<RepositoryEngine, T> action) throws IllegalStateException {
        Preconditions.checkState((boolean)this.isRepositoryAccessible(repository), (Object)("Repository not accessible " + repository));
        try {
            return this.repositoryManager.getRepository(repository).withEngine(action);
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException("Repository in incorrect state", (Throwable)((Object)e2));
        }
    }
}

