/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.data.NotificationData;
import com.atlassian.fisheye.spi.services.NotificationService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service(value="notificationService")
@AvailableToPlugins(value=NotificationService.class)
public class DefaultNotificationService
implements NotificationService {
    private final TxTemplate txTemplate;
    private final NotificationManager notificationManager;
    private final SPIUserUtils spiUserUtils;

    @Autowired
    public DefaultNotificationService(NotificationManager notificationManager, TxTemplate txTemplate, SPIUserUtils spiUserUtils) {
        this.notificationManager = notificationManager;
        this.spiUserUtils = spiUserUtils;
        this.txTemplate = txTemplate;
    }

    public void notify(final NotificationData notification) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws DbException {
                DefaultNotificationService.this.notificationManager.notePluginMsg(DefaultNotificationService.this.toUser(notification.getActioner()), DefaultNotificationService.this.toUsers(notification.getRecipients()), notification.getGroupType(), notification.getSubject(), notification.getHtmlBody(), notification.getTextBody());
                return null;
            }
        });
    }

    private Set<FecruUser> toUsers(Set<UserData> recipients) {
        HashSet<FecruUser> users = new HashSet<FecruUser>(Collections2.transform(recipients, (Function)new Function<UserData, FecruUser>(){

            public FecruUser apply(UserData userData) {
                return DefaultNotificationService.this.toUser(userData);
            }
        }));
        users.remove(null);
        return users;
    }

    private FecruUser toUser(UserData userData) {
        return userData == null ? null : this.spiUserUtils.getUser(userData);
    }
}

