/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.fisheye.gravatar.AvatarTypeInfo;
import com.atlassian.fisheye.spi.services.LinkService;
import com.atlassian.fisheye.web.NavBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service(value="navigationService")
@AvailableToPlugins
public class DefaultLinkService
implements LinkService {
    public String getChangelogAbsLink(HttpServletRequest request, String repositoryName, String branchName) {
        return NavBuilder.changelogAbs(request, repositoryName, branchName);
    }

    public String getChangesetAbsLink(HttpServletRequest request, String repositoryName, String csid) {
        return NavBuilder.changesetAbs(request, repositoryName, csid);
    }

    public String getProjectAbsLink(HttpServletRequest request, String projectKey) {
        return NavBuilder.projectAbs(request, projectKey);
    }

    public String getReviewAbsLink(HttpServletRequest request, String permaId) {
        return NavBuilder.reviewAbs(request, permaId);
    }

    public String getCommiterAbsLink(HttpServletRequest req, String repositoryName, String committerName) {
        return NavBuilder.committer(req, repositoryName, committerName);
    }

    public String getUserAbsLink(HttpServletRequest req, String userName) {
        return NavBuilder.userAbs(req, userName);
    }

    public String getAvatarAbsImgLink(HttpServletRequest req, String username, int size, boolean noCache) {
        return AvatarTypeInfo.getAvatarUrlAbs(req, username, size, noCache, false);
    }

    public String getDeletedAvatarAbsImgLink(HttpServletRequest req, int size) {
        return AvatarTypeInfo.getAvatarUrlAbs(req, null, size, false, true);
    }

    public String getUnknownAvatarAbsImgLink(HttpServletRequest req, int size) {
        return AvatarTypeInfo.getAvatarUrlAbs(req, null, size, false, false);
    }

    public String getStaticPathAbsLink(HttpServletRequest req) {
        return NavBuilder.getSiteUrl(req) + "/currentstatic";
    }
}

