/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.impl;

import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fisheye.spi.data.FileRevisionKeyData;
import com.atlassian.fisheye.spi.services.ContentService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.base.Function;
import java.io.OutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="contentService")
@AvailableToPlugins
public class DefaultContentService
implements ContentService {
    private final SPIUtils spiUtils;

    @Autowired
    public DefaultContentService(SPIUtils spiUtils) {
        this.spiUtils = spiUtils;
    }

    public void getContent(final String repository, final FileRevisionKeyData fileRevision, final OutputStream os) {
        this.spiUtils.withRepository(repository, new Function<RepositoryEngine, Void>(){

            public Void apply(RepositoryEngine input) {
                RevisionCache<? extends ChangeSet> cache = input.getRevisionCache();
                try {
                    cache.getTextRevision(new RevInfoKey(new Path(fileRevision.getPath()), fileRevision.getRev()), os, null, null);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error retrieving content for file revision" + fileRevision + " in repository " + repository, e2);
                }
                return null;
            }
        });
    }
}

