/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.CustomAuthSettings;
import com.atlassian.fisheye.spi.admin.data.CvsUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.ExternalAuthSettings;
import com.atlassian.fisheye.spi.admin.data.PolledUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.atlassian.fisheye.spi.admin.impl.AbstractRepositoryOptionsHelper;
import com.atlassian.fisheye.spi.admin.impl.AdminSpiUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ChangesetDiscussionsSettingsType;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.CustomRepositoryConfigType;
import com.cenqua.fisheye.config1.CvsUpdaterType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.HideDirType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.config1.PolledUpdaterType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.config1.WatchType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.math.BigInteger;
import java.util.List;

public class RepositoryOptionsHelper
extends AbstractRepositoryOptionsHelper {
    private final RepositoryHandle repHandle;
    private final RepositoryType repType;

    public RepositoryOptionsHelper(String repositoryName) {
        if (repositoryName == null) {
            throw new NullPointerException();
        }
        this.repHandle = AppConfig.getsConfig().getRepositoryManager().getRepository(repositoryName);
        this.repType = this.repHandle.getCfg().getRepositoryTypeConfig();
    }

    @Override
    protected LinkerType getLinkerType(boolean attach) {
        if (attach && !this.repType.isSetLinker()) {
            this.repType.addNewLinker();
        }
        return this.repType.isSetLinker() ? this.repType.getLinker() : LinkerType.Factory.newInstance();
    }

    @Override
    public void setSimpleLinkers(List<SimpleLinker> linkers) {
        super.setSimpleLinkers(linkers);
        LinkerType linkerType = this.getLinkerType(false);
        if (linkerType.sizeOfSimpleArray() == 0 && linkerType.sizeOfAdvancedArray() == 0) {
            this.repType.unsetLinker();
        }
    }

    @Override
    public void reloadLinkers() {
        this.repHandle.getCfg().setupLinker();
    }

    @Override
    public void reloadUpdateOptions() {
        this.repHandle.getCfg().getScmConfig().reloadUpdateSettings();
        if (this.repHandle.isRunning()) {
            this.repHandle.scheduleIncrementalIndexing(0L);
        }
    }

    @Override
    protected RepSecurityType getRepSecurityType(boolean attach) {
        if (attach && !this.repType.isSetSecurity()) {
            this.repType.addNewSecurity();
        }
        return this.repType.isSetSecurity() ? this.repType.getSecurity() : RepSecurityType.Factory.newInstance();
    }

    public boolean isUsingDefaultsPermissions() {
        RepSecurityType securityType = this.getRepSecurityType(false);
        return securityType.isSetUseDefaults() && securityType.getUseDefaults();
    }

    public void setUseDefaultsPermissions(boolean useDefaultsPermissions) {
        this.getRepSecurityType(true).setUseDefaults(useDefaultsPermissions);
    }

    @Override
    public boolean isAllowAnon() {
        RepSecurityType securityType = this.getRepSecurityType(false);
        return securityType.isSetAllowAnon() && securityType.getAllowAnon();
    }

    @Override
    public boolean isAllowLoggedUsers() {
        RepSecurityType securityType = this.getRepSecurityType(false);
        return securityType.isSetAllowLoggedIn() && securityType.getAllowLoggedIn();
    }

    private static void ensureNotUsingDefaultValue(boolean usingDefault) {
        if (usingDefault) {
            throw new IllegalStateException("repository is using the repository defaults value.");
        }
    }

    public void removeAllowAnon() {
        if (this.repType.isSetSecurity() && this.repType.getSecurity().isSetAllowAnon()) {
            this.repType.getSecurity().unsetAllowAnon();
        }
    }

    public void removeAllowAnonWrite() {
        if (this.repType.isSetSecurity() && this.repType.getSecurity().isSetAllowAnonWrite()) {
            this.repType.getSecurity().unsetAllowAnonWrite();
        }
    }

    public void removeAllowLoggedUsers() {
        if (this.repType.isSetSecurity() && this.repType.getSecurity().isSetAllowLoggedIn()) {
            this.repType.getSecurity().unsetAllowLoggedIn();
        }
    }

    public void removeAllowLoggedUsersWrite() {
        if (this.repType.isSetSecurity() && this.repType.getSecurity().isSetAllowLoggedInWrite()) {
            this.repType.getSecurity().unsetAllowLoggedInWrite();
        }
    }

    @Override
    protected WatchType getWatchType(boolean attach) {
        if (attach && !this.repType.isSetWatches()) {
            this.repType.addNewWatches();
        }
        return this.repType.isSetWatches() ? this.repType.getWatches() : WatchType.Factory.newInstance();
    }

    @Override
    public boolean isWatchesEnabled() {
        RepositoryOptionsHelper.ensureNotUsingDefaultValue(this.isUsingDefaultWatchesEnabled());
        return super.isWatchesEnabled();
    }

    public boolean isUsingDefaultWatchesEnabled() {
        return !this.repType.isSetWatches();
    }

    public void useDefaultWatchesEnabled() {
        if (this.repType.isSetWatches()) {
            this.repType.unsetWatches();
        }
    }

    public void removeRequiredGroups() {
        RepSecurityType securityType;
        if (this.repType.isSetSecurity() && (securityType = this.repType.getSecurity()).isSetRequiredGroups()) {
            securityType.unsetRequiredGroups();
        }
    }

    public void removeRequiredWriteGroups() {
        RepSecurityType securityType;
        if (this.repType.isSetSecurity() && (securityType = this.repType.getSecurity()).isSetRequiredWriteGroups()) {
            securityType.unsetRequiredWriteGroups();
        }
    }

    @Override
    protected ChangesetDiscussionsSettingsType getChangesetDiscussionsType(boolean attach) {
        if (attach && !this.repType.isSetChangesetDiscussions()) {
            this.repType.addNewChangesetDiscussions();
        }
        return this.repType.isSetChangesetDiscussions() ? this.repType.getChangesetDiscussions() : ChangesetDiscussionsSettingsType.Factory.newInstance();
    }

    @Override
    public boolean isChangesetDiscussionsEnabled() {
        RepositoryOptionsHelper.ensureNotUsingDefaultValue(this.isUsingDefaultChangesetDiscussionsEnabled());
        return super.isChangesetDiscussionsEnabled();
    }

    public boolean isUsingDefaultChangesetDiscussionsEnabled() {
        return !this.repType.isSetChangesetDiscussions();
    }

    public void useDefaultChangesetDiscussionsEnabled() {
        if (this.repType.isSetChangesetDiscussions()) {
            this.repType.unsetChangesetDiscussions();
        }
    }

    @Override
    protected AllowType getAllowType(boolean attach) {
        if (attach && !this.repType.isSetAllow()) {
            this.repType.addNewAllow();
        }
        return this.repType.isSetAllow() ? this.repType.getAllow() : AllowType.Factory.newInstance();
    }

    @Override
    public void setAllowIncludePaths(List<CaseAwarePath> includePaths) {
        super.setAllowIncludePaths(includePaths);
        this.cleanupAllowType();
    }

    @Override
    public void setAllowExcludeGlobs(List<CaseAwarePathGlob> excludeGlobs) {
        super.setAllowExcludeGlobs(excludeGlobs);
        this.cleanupAllowType();
    }

    private void cleanupAllowType() {
        AllowType allowType = this.getAllowType(true);
        if (allowType.sizeOfIncludeArray() == 0 && allowType.sizeOfExcludeArray() == 0) {
            this.repType.unsetAllow();
        }
    }

    @Override
    protected HideDirType[] getHideDirTypeArray() {
        return this.repType.getHideDirArray();
    }

    @Override
    protected void setHideDirTypeArray(HideDirType[] types) {
        this.repType.setHideDirArray(types);
    }

    @Override
    protected TarballType getTarballType(boolean attach) {
        if (attach && !this.repType.isSetTarball()) {
            this.repType.addNewTarball();
        }
        return this.repType.isSetTarball() ? this.repType.getTarball() : TarballType.Factory.newInstance();
    }

    @Override
    protected void setTarballType(TarballType tarballType) {
        this.repType.setTarball(tarballType);
    }

    @Override
    public TarballSettings getTarballSettings() {
        RepositoryOptionsHelper.ensureNotUsingDefaultValue(this.isUsingDefaultTarballSettings());
        return super.getTarballSettings();
    }

    public boolean isUsingDefaultTarballSettings() {
        return !this.repType.isSetTarball();
    }

    public void useDefaultTarballSettings() {
        if (this.repType.isSetTarball()) {
            this.repType.unsetTarball();
        }
    }

    @Override
    protected GroupListType getGroupsListType(boolean attach) {
        RepSecurityType securityType = this.getRepSecurityType(attach);
        if (attach && !securityType.isSetRequiredGroups()) {
            securityType.addNewRequiredGroups();
        }
        return securityType.isSetRequiredGroups() ? securityType.getRequiredGroups() : GroupListType.Factory.newInstance();
    }

    @Override
    public CommitMessageSyntaxType getCommitMessageSyntaxType(boolean attach) {
        if (attach && !this.repType.isSetCommitMessageSyntax()) {
            this.repType.addNewCommitMessageSyntax();
        }
        return this.repType.isSetCommitMessageSyntax() ? this.repType.getCommitMessageSyntax() : CommitMessageSyntaxType.Factory.newInstance();
    }

    @Override
    public CommitMessageSyntaxSettings getCommitMessageSyntaxSettings() {
        RepositoryOptionsHelper.ensureNotUsingDefaultValue(this.isUsingDefaultCommitMessageSyntaxSettings());
        return super.getCommitMessageSyntaxSettings();
    }

    @Override
    protected void setCommitMessageSyntaxType(CommitMessageSyntaxType commitMessageSyntaxType) {
        this.repType.setCommitMessageSyntax(commitMessageSyntaxType);
    }

    public boolean isUsingDefaultCommitMessageSyntaxSettings() {
        return !this.repType.isSetCommitMessageSyntax();
    }

    public void useDefaultCommitMessageSyntaxSettings() {
        if (this.repType.isSetCommitMessageSyntax()) {
            this.repType.unsetCommitMessageSyntax();
        }
    }

    public ExternalAuthSettings getExternalAuthSettings() {
        RepSecurityType security = this.getRepSecurityType(false);
        return security.isSetCustom() ? new CustomAuthSettings(security.getCustom().getConstraint()) : null;
    }

    public boolean isUsingDefaultMaxIndexableSize() {
        return !this.repType.isSetMaxIndexableSize();
    }

    public void setMaxIndexableSize(Long indexableSize) {
        this.repType.setMaxIndexableSize(BigInteger.valueOf(indexableSize));
    }

    public void useDefaultMaxIndexableSize() {
        if (this.repType.isSetMaxIndexableSize()) {
            this.repType.unsetMaxIndexableSize();
        }
    }

    public Long getMaxIndexableSize() {
        return this.repType.getMaxIndexableSize().longValue();
    }

    public void setExternalAuth(ExternalAuthSettings externalAuthSettings) {
        RepSecurityType type = this.getRepSecurityType(true);
        if (externalAuthSettings == null) {
            if (type.isSetCustom()) {
                type.unsetCustom();
            }
        } else if (externalAuthSettings instanceof CustomAuthSettings) {
            CustomRepositoryConfigType config = CustomRepositoryConfigType.Factory.newInstance();
            config.setConstraint(((CustomAuthSettings)externalAuthSettings).getConstraint());
            type.setCustom(config);
        }
    }

    public void useDefaultUpdateOptions() {
        AdminSpiUtil.unsetRepoUpdater(this.repType);
    }

    public boolean isUsingDefaultUpdateOptions() {
        return AdminSpiUtil.getCvsRepoUpdater(this.repType, false) == null && AdminSpiUtil.getPolledRepoUpdater(this.repType, false) == null;
    }

    public PolledUpdateOptions getUpdateOptions() {
        PolledUpdaterType polledUpdaterType = AdminSpiUtil.getPolledRepoUpdater(this.repType, false);
        CvsUpdaterType cvsUpdaterType = AdminSpiUtil.getCvsRepoUpdater(this.repType, false);
        if (polledUpdaterType != null) {
            return AdminSpiUtil.toPolledUpdateOptions(polledUpdaterType);
        }
        if (cvsUpdaterType != null) {
            return AdminSpiUtil.toCvsUpdateOptions(cvsUpdaterType);
        }
        return null;
    }

    public void setUpdateOptions(PolledUpdateOptions updateOptions) {
        if (updateOptions instanceof CvsUpdateOptions && this.repType.isSetCvs()) {
            AdminSpiUtil.setCvsUpdaterType((CvsUpdateOptions)updateOptions, AdminSpiUtil.getCvsRepoUpdater(this.repType, true));
        } else {
            AdminSpiUtil.setPolledUpdaterType(updateOptions, AdminSpiUtil.getPolledRepoUpdater(this.repType, true));
        }
    }
}

