/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fisheye.spi.admin.data.KeyPair;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.services.SshKeyService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sshKeyService")
@AvailableToPlugins
public class DefaultSshKeyService
implements SshKeyService {
    public static final Pattern KEY_NAME_REGEX = RepositoryData.NAME_REGEX;
    private final SshKeyManager sshKeyManager;

    @Autowired
    public DefaultSshKeyService(SshKeyManager sshKeyManager) {
        this.sshKeyManager = sshKeyManager;
    }

    public KeyPair generateKeyPair(String keyName) {
        this.validateKeyName(keyName);
        return this.sshKeyManager.generateKeyPair(keyName);
    }

    public String getPublicKeyContents(String keyName) throws IOException {
        this.validateKeyName(keyName);
        return this.sshKeyManager.getPublicKeyContents(keyName);
    }

    public boolean hasPublicKey(String keyName) {
        this.validateKeyName(keyName);
        File publicKeyFile = this.sshKeyManager.getPublicKey(keyName);
        return publicKeyFile != null && publicKeyFile.exists();
    }

    private void validateKeyName(String keyName) {
        if (keyName == null) {
            throw new NullPointerException("key name must not be null");
        }
        if (!KEY_NAME_REGEX.matcher(keyName).find()) {
            throw new IllegalArgumentException(String.format("key name '%s' doesn't match regex '%s'", keyName, KEY_NAME_REGEX.pattern()));
        }
    }
}

