/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions;
import com.atlassian.fisheye.spi.admin.impl.AbstractRepositoryOptionsHelper;
import com.atlassian.fisheye.spi.admin.impl.AdminSpiUtil;
import com.atlassian.fisheye.spi.admin.impl.RepositoryOptionsHelper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ChangesetDiscussionsSettingsType;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.DefaultUpdaterType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.HideDirType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.config1.WatchType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DefaultRepositoryOptionsHelper
extends AbstractRepositoryOptionsHelper {
    public static final DefaultRepositoryOptionsHelper INSTANCE = new DefaultRepositoryOptionsHelper();
    private final RepositoryDefaultsType repDefaultsType = AppConfig.getsConfig().getConfig().getRepositoryDefaults();

    private DefaultRepositoryOptionsHelper() {
    }

    private static RootConfig getRootCfg() {
        return AppConfig.getsConfig();
    }

    private static Map<String, RepositoryHandle> getRepHandleMap() {
        return AppConfig.getsConfig().getRepositoryManager().getHandleMap();
    }

    @Override
    protected LinkerType getLinkerType(boolean attach) {
        return this.repDefaultsType.getLinker();
    }

    @Override
    public void reloadLinkers() {
        DefaultRepositoryOptionsHelper.getRootCfg().reloadDefaultLinker();
        Collection<RepositoryHandle> repHandles = DefaultRepositoryOptionsHelper.getRepHandleMap().values();
        for (RepositoryHandle repHandle : repHandles) {
            if (!repHandle.isRunning() && !repHandle.isStarting()) continue;
            repHandle.getCfg().setupLinker();
        }
    }

    @Override
    public void reloadUpdateOptions() {
        Set<String> repNames = DefaultRepositoryOptionsHelper.getRepHandleMap().keySet();
        for (String repName : repNames) {
            RepositoryOptionsHelper repositoryOptionsHelper = new RepositoryOptionsHelper(repName);
            if (!repositoryOptionsHelper.isUsingDefaultUpdateOptions()) continue;
            repositoryOptionsHelper.reloadUpdateOptions();
        }
    }

    @Override
    protected RepSecurityType getRepSecurityType(boolean attach) {
        if (attach && !this.repDefaultsType.isSetSecurity()) {
            this.repDefaultsType.addNewSecurity();
        }
        return this.repDefaultsType.isSetSecurity() ? this.repDefaultsType.getSecurity() : RepSecurityType.Factory.newInstance();
    }

    @Override
    protected WatchType getWatchType(boolean attach) {
        if (attach && !this.repDefaultsType.isSetWatches()) {
            this.repDefaultsType.addNewWatches();
        }
        return this.repDefaultsType.isSetWatches() ? this.repDefaultsType.getWatches() : WatchType.Factory.newInstance();
    }

    @Override
    protected ChangesetDiscussionsSettingsType getChangesetDiscussionsType(boolean attach) {
        if (attach && !this.repDefaultsType.isSetChangesetDiscussions()) {
            this.repDefaultsType.addNewChangesetDiscussions();
        }
        return this.repDefaultsType.isSetChangesetDiscussions() ? this.repDefaultsType.getChangesetDiscussions() : ChangesetDiscussionsSettingsType.Factory.newInstance();
    }

    @Override
    protected AllowType getAllowType(boolean attach) {
        return this.repDefaultsType.getAllow();
    }

    @Override
    protected HideDirType[] getHideDirTypeArray() {
        return this.repDefaultsType.getHideDirArray();
    }

    @Override
    protected void setHideDirTypeArray(HideDirType[] types) {
        this.repDefaultsType.setHideDirArray(types);
    }

    @Override
    protected TarballType getTarballType(boolean attach) {
        return this.repDefaultsType.getTarball();
    }

    @Override
    protected void setTarballType(TarballType tarballType) {
        this.repDefaultsType.setTarball(tarballType);
    }

    protected Long getMaxIndexableSize() {
        if (!this.repDefaultsType.isSetMaxIndexableSize()) {
            return null;
        }
        return this.repDefaultsType.getMaxIndexableSize().longValue();
    }

    protected void setMaxIndexableSize(Long maxIndexableSize) {
        if (maxIndexableSize == null && this.repDefaultsType.isSetMaxIndexableSize()) {
            this.repDefaultsType.unsetMaxIndexableSize();
        } else if (maxIndexableSize != null) {
            this.repDefaultsType.setMaxIndexableSize(BigInteger.valueOf(maxIndexableSize));
        }
    }

    @Override
    public CommitMessageSyntaxType getCommitMessageSyntaxType(boolean attach) {
        if (attach && !this.repDefaultsType.isSetCommitMessageSyntax()) {
            this.repDefaultsType.addNewCommitMessageSyntax();
        }
        return this.repDefaultsType.isSetCommitMessageSyntax() ? this.repDefaultsType.getCommitMessageSyntax() : CommitMessageSyntaxType.Factory.newInstance();
    }

    @Override
    protected void setCommitMessageSyntaxType(CommitMessageSyntaxType commitMessageSyntaxType) {
        this.repDefaultsType.setCommitMessageSyntax(commitMessageSyntaxType);
    }

    @Override
    protected GroupListType getGroupsListType(boolean attach) {
        return this.getRepSecurityType(attach).getRequiredGroups();
    }

    public DefaultUpdateOptions getUpdateOptions() {
        if (this.repDefaultsType.isSetUpdater()) {
            DefaultUpdaterType updater = this.repDefaultsType.getUpdater();
            return AdminSpiUtil.toDefaultUpdateOptions(updater);
        }
        return DefaultUpdateOptions.DEFAULT;
    }

    public void setUpdateOptions(DefaultUpdateOptions updateOptions) {
        if (updateOptions == null) {
            updateOptions = DefaultUpdateOptions.DEFAULT;
        }
        this.repDefaultsType.setUpdater(AdminSpiUtil.toDefaultUpdaterType(updateOptions));
    }
}

