/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.fisheye.spi.admin.data.RepositoryIndexingStatus;
import com.atlassian.fisheye.spi.admin.data.RepositoryState;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.atlassian.fisheye.spi.admin.services.RepositoryConfigException;
import com.atlassian.fisheye.spi.admin.services.RepositoryIndexer;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.ping.CrossRepositoryRescanRequest;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultRepositoryIndexer
implements RepositoryIndexer {
    protected RepositoryAdminService repositoryAdminService;
    protected RepositoryHandle repositoryHandle;
    protected String name;
    private boolean valid = true;

    public DefaultRepositoryIndexer(RepositoryAdminService repositoryAdminService, RepositoryHandle repositoryHandle) {
        this.repositoryAdminService = repositoryAdminService;
        this.repositoryHandle = repositoryHandle;
        this.name = repositoryHandle.getName();
    }

    protected final void ensureRepositoryExists() {
        if (!this.valid || !this.repositoryAdminService.exists(this.name)) {
            this.valid = false;
            throw new IllegalStateException(String.format("Repository indexer has been invalidated because repository '%s' was deleted.", this.name));
        }
    }

    public RepositoryIndexingStatus getIndexingStatus() {
        this.ensureRepositoryExists();
        RepositoryStatus status = this.repositoryHandle.getStatus();
        boolean inProgress = status.isScanInProgress();
        boolean doingInitialSlurp = status.isDoingInitialSlurp();
        return new RepositoryIndexingStatus.Builder().fullIndex(inProgress && doingInitialSlurp).incrementalIndex(inProgress && !doingInitialSlurp).locIndex(status.isLocSlurpInProgress()).hasError(status.getEngineHasError()).message(status.getEngineHasError() ? status.getEngineError() : status.getMessage()).lastScanTime(status.getLastSlurpTime()).indexingStateCounts(this.transformIndexingStateCountsMap(status.getIndexingStateCounts())).doneFullRepositorySlurp(status.isInitialIndexingComplete()).initialScanningComplete(status.isInitialScanningComplete()).crossRepositoryRescanInProgress(CrossRepositoryRescanRequest.isRepositoryBeingReindexed(this.name)).build();
    }

    private Map<String, Number> transformIndexingStateCountsMap(Map<ChangeSetIndexingState, AtomicInteger> counts) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)counts.size());
        for (Map.Entry<ChangeSetIndexingState, AtomicInteger> entry : counts.entrySet()) {
            ret.put(entry.getKey().name(), entry.getValue().intValue());
        }
        return ret;
    }

    public RepositoryIndexingStatus startFullReindexing() throws RepositoryConfigException {
        this.ensureRepositoryExists();
        RepositoryState state = this.repositoryAdminService.getState(this.name);
        if (state != RepositoryState.STOPPED) {
            throw new IllegalStateException(String.format("Repository '%s' (currently %s) must be stopped before starting.", this.name, state));
        }
        try {
            this.repositoryHandle.deleteIndex();
        }
        catch (RepositoryHandle.StateException stateException) {
            // empty catch block
        }
        this.repositoryAdminService.start(this.name);
        try {
            this.repositoryHandle.oneOffScan(false);
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException(String.format("Repository '%s' did not start and index ping was not processed.", this.name));
        }
        return this.getIndexingStatus();
    }

    public RepositoryIndexingStatus startIncrementalIndexing() {
        this.ensureRepositoryExists();
        try {
            this.repositoryHandle.oneOffScan(false);
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException(String.format("Repository '%s' is not running and index ping was not processed.", this.name));
        }
        return this.getIndexingStatus();
    }

    public RepositoryIndexingStatus startLineCountReindexing() {
        this.ensureRepositoryExists();
        try {
            this.repositoryHandle.requestLinecountReindex();
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException(String.format("Repository '%s' is not running and linecount re-index was not processed.", this.name));
        }
        return this.getIndexingStatus();
    }

    public RepositoryIndexingStatus startChangesetCommentReindexing() {
        this.ensureRepositoryExists();
        try {
            this.repositoryHandle.requestChangesetCommentReindex();
        }
        catch (RepositoryHandle.StateException e2) {
            throw new IllegalStateException(String.format("Repository '%s' is not running and the changeset discussion re-index was not processed.", this.name));
        }
        return this.getIndexingStatus();
    }
}

