/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.impl;

import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.checkouturl.CheckoutURLAdminManager;
import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.security.SshKey;
import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.event.RepositoryCreatedEventImpl;
import com.atlassian.fisheye.event.RepositoryDeletedEventImpl;
import com.atlassian.fisheye.spi.admin.data.AuthenticationData;
import com.atlassian.fisheye.spi.admin.data.AuthenticationStyle;
import com.atlassian.fisheye.spi.admin.data.DefaultRepositoryOptions;
import com.atlassian.fisheye.spi.admin.data.GitRepositoryData;
import com.atlassian.fisheye.spi.admin.data.HasAuthenticationData;
import com.atlassian.fisheye.spi.admin.data.HgRepositoryData;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.spi.admin.data.PolledUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryState;
import com.atlassian.fisheye.spi.admin.data.RepositoryUpdateResult;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import com.atlassian.fisheye.spi.admin.data.UpdateOptions;
import com.atlassian.fisheye.spi.admin.impl.AdminSpiUtil;
import com.atlassian.fisheye.spi.admin.impl.DefaultDvcsRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryOptionsHelper;
import com.atlassian.fisheye.spi.admin.impl.RepositoryOptionsHelper;
import com.atlassian.fisheye.spi.admin.services.CvsRepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.atlassian.fisheye.spi.admin.services.RepositoryConfigException;
import com.atlassian.fisheye.spi.admin.services.RepositoryIndexer;
import com.atlassian.fisheye.spi.admin.services.RepositorySearchCriteria;
import com.atlassian.fisheye.spi.admin.services.RepositoryStateException;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryConfigFactory;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.HgRepType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.PasswordAuthenticationType;
import com.cenqua.fisheye.config1.PolledUpdaterType;
import com.cenqua.fisheye.config1.RenameOptions;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SshKeyAuthenticationType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.FileUtils;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.UrlUtils;
import com.cenqua.fisheye.util.XmlbeansUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryAdminService")
@AvailableToPlugins
public class DefaultRepositoryAdminService
implements RepositoryAdminService {
    private final RepositoryManager repositoryManager;
    private final SshKeyManager sshKeyManager;
    private final EventPublisher eventPublisher;
    private final EffectiveUserProvider effectiveUserProvider;
    private final CheckoutURLAdminManager checkoutUrlAdminManager;
    private final RepositoryConfigFactory repositoryConfigFactory;
    private final UserManager userManager;
    private final Lock configLock = new ReentrantLock();
    private static final int REPO_INDENT = 2;
    private static final long STOP_RUNNING_TIMEOUT_MS = 20000L;

    @Autowired
    public DefaultRepositoryAdminService(RepositoryManager repositoryManager, SshKeyManager sshKeyManager, EventPublisher eventPublisher, EffectiveUserProvider effectiveUserProvider, CheckoutURLAdminManager checkoutUrlAdminManager, RepositoryConfigFactory repositoryConfigFactory, UserManager userManager) {
        this.repositoryManager = repositoryManager;
        this.sshKeyManager = sshKeyManager;
        this.eventPublisher = eventPublisher;
        this.effectiveUserProvider = effectiveUserProvider;
        this.checkoutUrlAdminManager = checkoutUrlAdminManager;
        this.repositoryConfigFactory = repositoryConfigFactory;
        this.userManager = userManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNames() {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            HashSet<String> result = new HashSet<String>();
            for (RepositoryType repType : AppConfig.getsConfig().getConfig().getRepositoryArray()) {
                result.add(repType.getName());
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name) {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            if (name != null) {
                for (RepositoryType repType : AppConfig.getsConfig().getConfig().getRepositoryArray()) {
                    if (!name.equalsIgnoreCase(repType.getName())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RepositoryData> getRepositories() {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            TreeSet<RepositoryData> result = new TreeSet<RepositoryData>(new Comparator<RepositoryData>(){

                @Override
                public int compare(RepositoryData repositoryData1, RepositoryData repositoryData2) {
                    return repositoryData1.getName().compareTo(repositoryData2.getName());
                }
            });
            for (RepositoryType repType : AppConfig.getsConfig().getConfig().getRepositoryArray()) {
                result.add(this.getRepositoryData(repType.getName()));
            }
            TreeSet<RepositoryData> treeSet = result;
            return treeSet;
        }
        finally {
            this.configLock.unlock();
        }
    }

    public Page<RepositoryData> searchRepositories(RepositorySearchCriteria repositorySearchCriteria, PageRequest pageRequest) {
        Set<RepositoryData> repositoriesData = this.getRepositories();
        Predicate filter = Predicates.and((Predicate[])new Predicate[]{this.typePredicate(repositorySearchCriteria.type), this.enabledPredicate(repositorySearchCriteria.enabled), this.startedPredicate(repositorySearchCriteria.started)});
        Set repositoriesDataFiltered = Sets.filter(repositoriesData, (Predicate)filter);
        return Page.Builder.buildFromAllDataIterable((Iterable)repositoriesDataFiltered, (PageRequest)pageRequest);
    }

    private Predicate<RepositoryData> typePredicate(final String type) {
        return new Predicate<RepositoryData>(){

            public boolean apply(RepositoryData repositoryData) {
                return type == null || type.equalsIgnoreCase(repositoryData.getType().name);
            }
        };
    }

    private Predicate<RepositoryData> enabledPredicate(final Boolean enabled) {
        return new Predicate<RepositoryData>(){

            public boolean apply(RepositoryData repositoryData) {
                return enabled == null || enabled.booleanValue() == DefaultRepositoryAdminService.this.isEnabled(repositoryData.getName());
            }
        };
    }

    private Predicate<RepositoryData> startedPredicate(final Boolean started) {
        return new Predicate<RepositoryData>(){

            public boolean apply(RepositoryData repositoryData) {
                if (started == null) {
                    return true;
                }
                if (!DefaultRepositoryAdminService.this.isEnabled(repositoryData.getName())) {
                    return started == false;
                }
                RepositoryState state = DefaultRepositoryAdminService.this.getState(repositoryData.getName());
                boolean stateRunning = state == RepositoryState.RUNNING;
                return started == stateRunning;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryData getRepositoryData(String name) {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryHandle repHandle = this.getRepositoryHandle(name);
            RepositoryData repositoryData = AdminSpiUtil.toRepositoryData(repHandle.getCfg().getRepositoryTypeConfig());
            return repositoryData;
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void ensureRepositoryExists(String name) {
        this.getRepositoryHandle(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryOptions getRepositoryOptions(String repoName) {
        this.ensureAdminPermission();
        this.ensureRepositoryExists(repoName);
        this.configLock.lock();
        try {
            RepositoryOptions options = new RepositoryOptions();
            RepositoryOptionsHelper helper = new RepositoryOptionsHelper(repoName);
            boolean usingDefaultPermissions = helper.isUsingDefaultsPermissions();
            options.setUsingDefaultsPermissions(usingDefaultPermissions);
            options.setAllowAnon(helper.isAllowAnon() && !usingDefaultPermissions);
            options.setAllowLoggedUsers(helper.isAllowLoggedUsers() && !usingDefaultPermissions);
            if (helper.isUsingDefaultChangesetDiscussionsEnabled()) {
                options.setChangesetDiscussionsEnabled(null);
            } else {
                options.setChangesetDiscussionsEnabled(Boolean.valueOf(helper.isChangesetDiscussionsEnabled()));
            }
            if (helper.isUsingDefaultWatchesEnabled()) {
                options.setWatchesEnabled(null);
            } else {
                options.setWatchesEnabled(Boolean.valueOf(helper.isWatchesEnabled()));
            }
            options.setSimpleLinkers(helper.getSimpleLinkers());
            options.setAdvancedLinkers(helper.getAdvancedLinkers());
            options.setAllowIncludes(helper.getAllowIncludePaths());
            options.setAllowExcludes(helper.getAllowExcludeGlobs());
            options.setHiddenDirectories(helper.getHiddenDirectories());
            options.setRequiredGroups(helper.getRequiredGroups());
            options.setExternalAuthSettings(helper.getExternalAuthSettings());
            if (helper.isUsingDefaultCommitMessageSyntaxSettings()) {
                options.setCommitMessageSyntaxSettings(null);
            } else {
                options.setCommitMessageSyntaxSettings(helper.getCommitMessageSyntaxSettings());
            }
            if (helper.isUsingDefaultTarballSettings()) {
                options.setTarballSettings(null);
            } else {
                options.setTarballSettings(helper.getTarballSettings());
            }
            if (helper.isUsingDefaultMaxIndexableSize()) {
                options.setMaxIndexableSize(null);
            } else {
                options.setMaxIndexableSize(helper.getMaxIndexableSize());
            }
            if (helper.isUsingDefaultUpdateOptions()) {
                options.setUpdateOptions(null);
            } else {
                options.setUpdateOptions((UpdateOptions)helper.getUpdateOptions());
            }
            options.setShowCheckoutURL(this.checkoutUrlAdminManager.getRepositoryShowCheckoutUrl(repoName));
            Map<String, String> checkoutUrl = this.checkoutUrlAdminManager.getCheckoutUrl(repoName);
            options.setCheckoutURL(checkoutUrl == null ? this.checkoutUrlAdminManager.getDefaultCheckoutUrl(repoName, null) : checkoutUrl);
            RepositoryOptions repositoryOptions = options;
            return repositoryOptions;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepositoryOptions(String repoName, RepositoryOptions options) throws RepositoryConfigException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions existingOptions = this.getRepositoryOptions(repoName);
            if (!existingOptions.equals((Object)options)) {
                RepositoryOptionsHelper helper = new RepositoryOptionsHelper(repoName);
                boolean usingDefaultsPermissions = options.isUsingDefaultsPermissions();
                if (usingDefaultsPermissions) {
                    helper.setUseDefaultsPermissions(true);
                    helper.removeAllowAnon();
                    helper.removeAllowAnonWrite();
                    helper.removeAllowLoggedUsers();
                    helper.removeAllowLoggedUsersWrite();
                    helper.removeRequiredGroups();
                    helper.removeRequiredWriteGroups();
                } else {
                    helper.setUseDefaultsPermissions(false);
                    helper.setAllowAnon(options.isAllowAnon());
                    helper.setAllowLoggedUsers(options.isAllowLoggedUsers());
                    helper.setRequiredGroups(options.getRequiredGroups());
                    helper.removeAllowAnonWrite();
                    helper.removeAllowLoggedUsersWrite();
                    helper.removeRequiredWriteGroups();
                }
                if (options.isChangesetDiscussionsEnabled() == null) {
                    helper.useDefaultChangesetDiscussionsEnabled();
                } else {
                    helper.setChangesetDiscussionEnabled(options.isChangesetDiscussionsEnabled());
                }
                if (options.isWatchesEnabled() == null) {
                    helper.useDefaultWatchesEnabled();
                } else {
                    helper.setWatchesEnabled(options.isWatchesEnabled());
                }
                helper.setSimpleLinkers(options.getSimpleLinkers());
                helper.setAdvancedLinkers(options.getAdvancedLinkers());
                helper.setAllowIncludePaths(options.getAllowIncludes());
                helper.setAllowExcludeGlobs(options.getAllowExcludes());
                helper.setHiddenDirectories(options.getHiddenDirectories());
                helper.setExternalAuth(options.getExternalAuthSettings());
                if (options.getCommitMessageSyntaxSettings() == null) {
                    helper.useDefaultCommitMessageSyntaxSettings();
                } else {
                    helper.setCommitMessageSyntaxSettings(options.getCommitMessageSyntaxSettings());
                }
                if (options.getTarballSettings() == null) {
                    helper.useDefaultTarballSettings();
                } else {
                    helper.setTarballSettings(options.getTarballSettings());
                }
                if (options.getMaxIndexableSize() == null) {
                    helper.useDefaultMaxIndexableSize();
                } else {
                    helper.setMaxIndexableSize(options.getMaxIndexableSize());
                }
                if (options.getUpdateOptions() == null) {
                    helper.useDefaultUpdateOptions();
                } else if (options.getUpdateOptions() instanceof PolledUpdateOptions) {
                    helper.setUpdateOptions((PolledUpdateOptions)options.getUpdateOptions());
                }
                this.saveConfig();
                if (!existingOptions.getSimpleLinkers().equals(options.getSimpleLinkers())) {
                    helper.reloadLinkers();
                }
                if (!Objects.equal((Object)existingOptions.getUpdateOptions(), (Object)options.getUpdateOptions())) {
                    helper.reloadUpdateOptions();
                }
                this.checkoutUrlAdminManager.setRepositoryShowCheckoutUrl(repoName, options.getShowCheckoutURL());
                Map newCheckoutURL = null;
                if (options.getCheckoutURL() != null && !options.getCheckoutURL().equals(this.checkoutUrlAdminManager.getDefaultCheckoutUrl(repoName, null))) {
                    newCheckoutURL = options.getCheckoutURL();
                }
                this.checkoutUrlAdminManager.setCheckoutUrl(repoName, newCheckoutURL);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepositoryUpdateOptions(String repositoryName, UpdateOptions options) throws RepositoryConfigException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            repositoryOptions.setUpdateOptions(options);
            this.setRepositoryOptions(repositoryName, repositoryOptions);
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void ensurePermissionPropertiesAllowsForGroups(RepositoryOptions repositoryOptions) {
        Preconditions.checkState((!repositoryOptions.isUsingDefaultsPermissions() ? 1 : 0) != 0, (Object)"permissions/groups are disabled when useDefaults is true; to get/modify repository allowed groups change useDefaults to false;");
        Preconditions.checkState((!repositoryOptions.isAllowAnon() ? 1 : 0) != 0, (Object)"permissions/groups are disabled when allowAnonymous is true; to get/modify repository allowed groups change allowAnonymous to false;");
        Preconditions.checkState((!repositoryOptions.isAllowLoggedUsers() ? 1 : 0) != 0, (Object)"permissions/groups are disabled when allowLoggedIn is true; to get/modify repository allowed groups change allowLoggedIn to false;");
    }

    private void ensureGroupExists(String groupName) throws NotFoundException {
        if (!this.userManager.groupExists(groupName)) {
            throw new IllegalArgumentException(String.format("Group '%s' does not exist.", groupName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequiredGroup(String repositoryName, String groupName) throws NotPermittedException, RepositoryConfigException, NotFoundException, IllegalStateException, IllegalArgumentException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            this.ensurePermissionPropertiesAllowsForGroups(repositoryOptions);
            this.ensureGroupExists(groupName);
            if (repositoryOptions.getRequiredGroups().add(groupName)) {
                this.setRepositoryOptions(repositoryName, repositoryOptions);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequiredGroup(String repositoryName, String groupName) throws NotPermittedException, RepositoryConfigException, NotFoundException, IllegalStateException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            this.ensurePermissionPropertiesAllowsForGroups(repositoryOptions);
            if (repositoryOptions.getRequiredGroups().remove(groupName)) {
                this.setRepositoryOptions(repositoryName, repositoryOptions);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<String> getRequiredGroups(String repositoryName, PageRequest pageRequest) throws NotPermittedException, NotFoundException, IllegalStateException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            Page groupPage;
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            this.ensurePermissionPropertiesAllowsForGroups(repositoryOptions);
            TreeSet allowedGroups = new TreeSet(repositoryOptions.getRequiredGroups());
            Page page = groupPage = Page.Builder.buildFromAllDataIterable(allowedGroups, (PageRequest)pageRequest);
            return page;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseDefaults(String repositoryName, boolean useDefaults) throws NotPermittedException, RepositoryConfigException, NotFoundException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            repositoryOptions.setUsingDefaultsPermissions(useDefaults);
            this.setRepositoryOptions(repositoryName, repositoryOptions);
        }
        finally {
            this.configLock.unlock();
        }
    }

    public boolean getUseDefaults(String repositoryName) throws NotPermittedException, NotFoundException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            boolean bl = this.getRepositoryOptions(repositoryName).isUsingDefaultsPermissions();
            return bl;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowAnonymous(String repositoryName, boolean allowAnonymous) throws NotPermittedException, RepositoryConfigException, NotFoundException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            repositoryOptions.setAllowAnon(allowAnonymous);
            this.setRepositoryOptions(repositoryName, repositoryOptions);
        }
        finally {
            this.configLock.unlock();
        }
    }

    public boolean getAllowAnonymous(String repositoryName) throws NotPermittedException, NotFoundException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            boolean bl = this.getRepositoryOptions(repositoryName).isAllowAnon();
            return bl;
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowLoggedIn(String repositoryName, boolean allowLoggedIn) throws NotPermittedException, RepositoryConfigException, NotFoundException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            RepositoryOptions repositoryOptions = this.getRepositoryOptions(repositoryName);
            repositoryOptions.setAllowLoggedUsers(allowLoggedIn);
            this.setRepositoryOptions(repositoryName, repositoryOptions);
        }
        finally {
            this.configLock.unlock();
        }
    }

    public boolean getAllowLoggedIn(String repositoryName) throws NotPermittedException, NotFoundException {
        this.ensureAdminPermission();
        this.configLock.lock();
        try {
            boolean bl = this.getRepositoryOptions(repositoryName).isAllowLoggedUsers();
            return bl;
        }
        finally {
            this.configLock.unlock();
        }
    }

    public DefaultRepositoryOptions getDefaultOptions() {
        this.ensureAdminPermission();
        DefaultRepositoryOptions defaultOptions = new DefaultRepositoryOptions();
        DefaultRepositoryOptionsHelper helper = DefaultRepositoryOptionsHelper.INSTANCE;
        defaultOptions.setAllowAnon(helper.isAllowAnon());
        defaultOptions.setAllowLoggedUsers(helper.isAllowLoggedUsers());
        defaultOptions.setChangesetDiscussionsEnabled(helper.isChangesetDiscussionsEnabled());
        defaultOptions.setWatchesEnabled(helper.isWatchesEnabled());
        defaultOptions.setSimpleLinkers(helper.getSimpleLinkers());
        defaultOptions.setAdvancedLinkers(helper.getAdvancedLinkers());
        defaultOptions.setAllowIncludes(helper.getAllowIncludePaths());
        defaultOptions.setAllowExcludes(helper.getAllowExcludeGlobs());
        defaultOptions.setHiddenDirectories(helper.getHiddenDirectories());
        defaultOptions.setTarballSettings(helper.getTarballSettings());
        defaultOptions.setCommitMessageSyntaxSettings(helper.getCommitMessageSyntaxSettings());
        defaultOptions.setRequiredGroups(helper.getRequiredGroups());
        defaultOptions.setMaxIndexableSize(helper.getMaxIndexableSize());
        defaultOptions.setUpdateOptions(helper.getUpdateOptions());
        defaultOptions.setShowCheckoutURLs(Boolean.valueOf(this.checkoutUrlAdminManager.getDefaultShowCheckoutUrl()));
        return defaultOptions;
    }

    public void setDefaultOptions(DefaultRepositoryOptions options) throws RepositoryConfigException {
        this.ensureAdminPermission();
        DefaultRepositoryOptions existingOptions = this.getDefaultOptions();
        if (!existingOptions.equals((Object)options)) {
            DefaultRepositoryOptionsHelper helper = DefaultRepositoryOptionsHelper.INSTANCE;
            helper.setAllowAnon(options.isAllowAnon());
            helper.setAllowLoggedUsers(options.isAllowLoggedUsers());
            helper.setWatchesEnabled(options.isWatchesEnabled());
            helper.setChangesetDiscussionEnabled(options.isChangesetDiscussionsEnabled());
            helper.setSimpleLinkers(options.getSimpleLinkers());
            helper.setAdvancedLinkers(options.getAdvancedLinkers());
            helper.setAllowIncludePaths(options.getAllowIncludes());
            helper.setAllowExcludeGlobs(options.getAllowExcludes());
            helper.setHiddenDirectories(options.getHiddenDirectories());
            helper.setTarballSettings(options.getTarballSettings());
            helper.setCommitMessageSyntaxSettings(options.getCommitMessageSyntaxSettings());
            helper.setRequiredGroups(options.getRequiredGroups());
            helper.setMaxIndexableSize(options.getMaxIndexableSize());
            helper.setUpdateOptions(options.getUpdateOptions());
            this.checkoutUrlAdminManager.setDefaultShowCheckoutUrl(options.getShowCheckoutURLs());
            this.saveConfig();
            if (!existingOptions.getSimpleLinkers().equals(options.getSimpleLinkers()) || !existingOptions.getAdvancedLinkers().equals(options.getAdvancedLinkers())) {
                helper.reloadLinkers();
            }
            if (!Objects.equal((Object)existingOptions.getUpdateOptions(), (Object)options.getUpdateOptions())) {
                helper.reloadUpdateOptions();
            }
        }
    }

    public RepositoryOptions getEffectiveOptions(String name) {
        DefaultRepositoryOptions defaultOptions = this.getDefaultOptions();
        RepositoryOptions repOptions = this.getRepositoryOptions(name);
        RepositoryOptions effectiveOptions = new RepositoryOptions();
        if (repOptions.isUsingDefaultsPermissions()) {
            effectiveOptions.setAllowAnon(defaultOptions.isAllowAnon());
            effectiveOptions.setAllowLoggedUsers(defaultOptions.isAllowLoggedUsers());
            effectiveOptions.setRequiredGroups(defaultOptions.getRequiredGroups());
        } else {
            effectiveOptions.setAllowAnon(repOptions.isAllowAnon());
            effectiveOptions.setAllowLoggedUsers(repOptions.isAllowLoggedUsers());
            effectiveOptions.setRequiredGroups(repOptions.getRequiredGroups());
        }
        if (repOptions.isWatchesEnabled() == null) {
            effectiveOptions.setWatchesEnabled(Boolean.valueOf(defaultOptions.isWatchesEnabled()));
        } else {
            effectiveOptions.setWatchesEnabled(repOptions.isWatchesEnabled());
        }
        List simpleLinkers = defaultOptions.getSimpleLinkers();
        simpleLinkers.addAll(repOptions.getSimpleLinkers());
        effectiveOptions.setSimpleLinkers(simpleLinkers);
        List advancedLinkers = defaultOptions.getAdvancedLinkers();
        advancedLinkers.addAll(repOptions.getAdvancedLinkers());
        effectiveOptions.setAdvancedLinkers(advancedLinkers);
        List allowIncludes = defaultOptions.getAllowIncludes();
        allowIncludes.addAll(repOptions.getAllowIncludes());
        effectiveOptions.setAllowIncludes(allowIncludes);
        List allowExcludes = defaultOptions.getAllowExcludes();
        allowExcludes.addAll(repOptions.getAllowExcludes());
        effectiveOptions.setAllowExcludes(allowExcludes);
        List hiddenDirectories = defaultOptions.getHiddenDirectories();
        hiddenDirectories.addAll(repOptions.getHiddenDirectories());
        effectiveOptions.setHiddenDirectories(hiddenDirectories);
        if (repOptions.getTarballSettings() == null) {
            effectiveOptions.setTarballSettings(defaultOptions.getTarballSettings());
        } else {
            List allExcludes = defaultOptions.getTarballSettings().getExcludes();
            allExcludes.addAll(repOptions.getTarballSettings().getExcludes());
            TarballSettings effectiveTarballSettings = repOptions.getTarballSettings();
            effectiveTarballSettings.setExcludes(allExcludes);
            effectiveOptions.setTarballSettings(effectiveTarballSettings);
        }
        if (repOptions.getUpdateOptions() == null) {
            effectiveOptions.setUpdateOptions(defaultOptions.getUpdateOptions().forRepoType(this.getRepositoryData(name).getType()));
        } else {
            effectiveOptions.setUpdateOptions(repOptions.getUpdateOptions());
        }
        effectiveOptions.setChangesetDiscussionsEnabled(Boolean.valueOf(defaultOptions.isChangesetDiscussionsEnabled()));
        if (repOptions.isChangesetDiscussionsEnabled() != null) {
            effectiveOptions.setChangesetDiscussionsEnabled(repOptions.isChangesetDiscussionsEnabled());
        }
        effectiveOptions.setCommitMessageSyntaxSettings(defaultOptions.getCommitMessageSyntaxSettings());
        if (repOptions.getCommitMessageSyntaxSettings() != null) {
            effectiveOptions.setCommitMessageSyntaxSettings(repOptions.getCommitMessageSyntaxSettings());
        }
        effectiveOptions.setShowCheckoutURL(defaultOptions.getShowCheckoutURLs());
        if (repOptions.getShowCheckoutURL() != null) {
            effectiveOptions.setShowCheckoutURL(repOptions.getShowCheckoutURL());
        }
        effectiveOptions.setMaxIndexableSize(defaultOptions.getMaxIndexableSize());
        if (repOptions.getMaxIndexableSize() != null) {
            effectiveOptions.setMaxIndexableSize(repOptions.getMaxIndexableSize());
        }
        effectiveOptions.setCheckoutURL(repOptions.getCheckoutURL());
        effectiveOptions.setExternalAuthSettings(repOptions.getExternalAuthSettings());
        return effectiveOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(RepositoryData repData) throws RepositoryConfigException {
        this.ensureAdminPermission();
        if (this.exists(repData.getName())) {
            throw new IllegalArgumentException(String.format("Repository '%s' already exists.", repData.getName()));
        }
        repData = this.postValidationPreCreationVisitor(repData);
        this.configLock.lock();
        try {
            DefaultRepositoryAdminService.setDefaultsForCreate(repData);
            RepositoryType repType = AdminSpiUtil.toRepositoryType(repData);
            int configIndex = AppConfig.getsConfig().addRepositoryType(repType);
            XmlbeansUtil.placeOnNewLine(AppConfig.getsConfig().getRepositoryType(configIndex), 2);
            this.saveConfig();
        }
        finally {
            this.configLock.unlock();
        }
        this.eventPublisher.publish((Object)new RepositoryCreatedEventImpl(repData.getName(), repData.getType().name));
        try {
            this.repositoryManager.reloadList();
        }
        catch (ConfigException e2) {
            throw new RepositoryConfigException(String.format("Problem reloading configuration when creating '%s'.", repData.getName()), (Throwable)e2);
        }
    }

    private static void setDefaultsForCreate(RepositoryData repData) {
        if (repData.getEnabled() == null) {
            repData.setEnabled(Boolean.FALSE);
        }
    }

    private SshKey createSshKeysForRepository(RepositoryData repData) throws IOException, JSchException {
        AuthenticationData authData;
        if (repData instanceof HasAuthenticationData && (authData = ((HasAuthenticationData)repData).getAuthentication()) != null && StringUtils.isNotEmpty((String)authData.getPrivateKey())) {
            SshKey key = this.sshKeyManager.saveKeyPair(repData.getName(), authData.getPublicKey(), authData.getPrivateKey());
            authData.setKeyName(key.getName());
            return key;
        }
        return null;
    }

    private RepositoryData postValidationPreCreationVisitor(final RepositoryData repData) throws RepositoryConfigException {
        StringBuilder error = new StringBuilder();
        try {
            this.createSshKeysForRepository(repData);
        }
        catch (Exception e2) {
            String message = "Failed to save ssh key (pair) for repository '" + repData.getName() + "', " + e2.getMessage();
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            error.append(message);
        }
        RepositoryData result = (RepositoryData)repData.getType().visit((RepositoryData.Type.Visitor)new RepositoryData.Type.Visitor<RepositoryData>(){

            public RepositoryData visitCvs() {
                return repData;
            }

            public RepositoryData visitSvn() {
                return repData;
            }

            public RepositoryData visitGit() {
                return this.cleanGitUrl((GitRepositoryData)repData);
            }

            public RepositoryData visitP4() {
                return repData;
            }

            public RepositoryData visitClearcase() {
                return repData;
            }

            public RepositoryData visitHg() {
                return this.cleanHgUrl((HgRepositoryData)repData);
            }

            private RepositoryData cleanHgUrl(HgRepositoryData repData2) {
                if (UrlUtils.isUrl(repData2.getLocation())) {
                    UrlUtils.UrlDetails urlDetails = UrlUtils.parse(repData2.getLocation());
                    if (!Strings.isNullOrEmpty((String)urlDetails.password)) {
                        String cleanUrl = UrlUtils.addAuthentication(urlDetails.protocol + urlDetails.simpleUrl, urlDetails.username);
                        repData2.setLocation(cleanUrl);
                        if (repData2.getAuthentication() == null) {
                            repData2.setAuthentication(new AuthenticationData());
                        }
                        repData2.getAuthentication().setPassword(urlDetails.password);
                        repData2.getAuthentication().setAuthenticationStyle(AuthenticationStyle.PASSWORD);
                    }
                }
                return repData2;
            }

            private GitRepositoryData cleanGitUrl(GitRepositoryData repData2) {
                if (UrlUtils.isUrl(repData2.getLocation())) {
                    UrlUtils.UrlDetails urlDetails = UrlUtils.parse(repData2.getLocation());
                    if (!Strings.isNullOrEmpty((String)urlDetails.password)) {
                        String cleanUrl = UrlUtils.addAuthentication(urlDetails.protocol + urlDetails.simpleUrl, urlDetails.username);
                        repData2.setLocation(cleanUrl);
                        if (repData2.getAuthentication() == null) {
                            repData2.setAuthentication(new AuthenticationData());
                        }
                        repData2.getAuthentication().setPassword(urlDetails.password);
                        repData2.getAuthentication().setAuthenticationStyle(AuthenticationStyle.PASSWORD);
                    }
                }
                return repData2;
            }
        });
        if (error.length() > 0) {
            throw new RepositoryConfigException(error.toString());
        }
        return result;
    }

    public void testConnectionFor(RepositoryData repData) throws RepositoryConfigException {
        this.ensureAdminPermission();
        SshKey createdKey = null;
        try {
            RepositoryType repType;
            try {
                createdKey = this.createSshKeysForRepository(repData);
            }
            catch (Exception e2) {
                String message = "Failed to save ssh key (pair) for repository '" + repData.getName() + "'.";
                throw new RepositoryConfigException(message, (Throwable)e2);
            }
            RepositoryHandle existingRepo = this.repositoryManager.getRepository(repData.getName());
            if (existingRepo == null) {
                repType = AdminSpiUtil.toRepositoryType(repData);
            } else {
                RepositoryType existingRepType = (RepositoryType)existingRepo.getCfg().getRepositoryTypeConfig().copy();
                this.update(existingRepType, AdminSpiUtil.toRepositoryType(repData));
                repType = existingRepType;
            }
            RepositoryConfig repoConfig = this.repositoryConfigFactory.createRepositoryConfig(repType, new NullLicenseEnforcer());
            if (repoConfig.getConfigException() != null) {
                throw new RepositoryConfigException((Throwable)repoConfig.getConfigException());
            }
            repoConfig.testConnection();
        }
        catch (ConfigException e3) {
            throw new RepositoryConfigException((Throwable)e3);
        }
        finally {
            if (createdKey != null) {
                this.sshKeyManager.removeKey(createdKey.getName());
            }
        }
    }

    private String getSshKeyName(RepositoryType repType) {
        if (repType.isSetHg() && repType.getHg().isSetSshAuth()) {
            return repType.getHg().getSshAuth().getKeyName();
        }
        if (repType.isSetGit() && repType.getGit().isSetSshAuth()) {
            return repType.getGit().getSshAuth().getKeyName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryUpdateResult update(RepositoryData repData) throws RepositoryConfigException {
        this.ensureAdminPermission();
        RepositoryData existingRepData = this.getRepositoryData(repData.getName());
        Preconditions.checkArgument((boolean)existingRepData.getType().equals((Object)repData.getType()), (String)"Can't change repository type from: %s to %s", (Object[])new Object[]{existingRepData.getType(), repData.getType()});
        DefaultRepositoryAdminService.setDefaultsForUpdate(repData, existingRepData);
        try {
            this.createSshKeysForRepository(repData);
        }
        catch (Exception e2) {
            String message = "Failed to save ssh key (pair) for repository '" + repData.getName() + "'.";
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            throw new RepositoryConfigException(message);
        }
        this.configLock.lock();
        try {
            RepositoryHandle repositoryHandle = this.getRepositoryHandle(repData.getName());
            RepositoryType existing = repositoryHandle.getCfg().getRepositoryTypeConfig();
            String oldKeyName = this.getSshKeyName(existing);
            RepositoryType updated = AdminSpiUtil.toRepositoryType(repData);
            RepositoryUpdateResult updateResult = this.update(existing, updated);
            this.saveConfig();
            String newKeyName = this.getSshKeyName(existing);
            if (oldKeyName != null && !oldKeyName.equals(newKeyName)) {
                this.sshKeyManager.removeKey(oldKeyName);
            }
            RepositoryUpdateResult repositoryUpdateResult = updateResult;
            return repositoryUpdateResult;
        }
        finally {
            this.configLock.unlock();
        }
    }

    private static void setDefaultsForUpdate(RepositoryData update, RepositoryData existing) {
        if (update.getEnabled() == null) {
            update.setEnabled(existing.getEnabled());
        }
    }

    private RepositoryUpdateResult update(RepositoryType existing, RepositoryType updated) {
        RepositoryUpdateResult scmResult;
        RepositoryUpdateResult commonResult = this.updateCommonFields(existing, updated);
        if (updated.isSetSvn()) {
            scmResult = this.updateSvn(existing, updated);
        } else if (updated.isSetCvs()) {
            scmResult = this.updateCvs(existing, updated);
        } else if (updated.isSetPerforce()) {
            scmResult = this.updateP4(existing, updated);
        } else if (updated.isSetGit()) {
            scmResult = this.updateGit(existing, updated);
        } else {
            if (updated.isSetClearcase()) {
                throw new RuntimeException("ClearCase is no longer supported.");
            }
            if (updated.isSetHg()) {
                scmResult = this.updateHg(existing, updated);
            } else {
                throw new AssertionError((Object)"Unknown repository type.");
            }
        }
        boolean isRunning = false;
        if (this.isEnabled(existing.getName())) {
            RepositoryState state = this.getState(existing.getName());
            isRunning = state == RepositoryState.RUNNING || state == RepositoryState.STARTING;
        }
        return new RepositoryUpdateResult(isRunning && (commonResult.isRestartRequired() || scmResult.isRestartRequired()), commonResult.isReindexRequired() || scmResult.isReindexRequired());
    }

    private RepositoryUpdateResult updateCommonFields(RepositoryType existing, RepositoryType updated) {
        RepositoryUpdateResult updateResult = DefaultRepositoryAdminService.checkForCommonRestartReindex(existing, updated);
        if (updated.isSetDescription()) {
            existing.setDescription(updated.getDescription());
        }
        if (updated.isSetStoreDiff()) {
            existing.setStoreDiff(updated.getStoreDiff());
        }
        existing.setEnabled(updated.getEnabled());
        return updateResult;
    }

    private PasswordAuthenticationType updatePasswordAuth(PasswordAuthenticationType existing, PasswordAuthenticationType updated) {
        if (existing == null) {
            existing = PasswordAuthenticationType.Factory.newInstance();
        }
        if (StringUtils.isNotEmpty((String)updated.getPassword())) {
            existing.setPassword(updated.getPassword());
        }
        return existing;
    }

    private SshKeyAuthenticationType updateSshAuth(SshKeyAuthenticationType existing, SshKeyAuthenticationType updated) {
        if (existing == null) {
            existing = SshKeyAuthenticationType.Factory.newInstance();
        }
        if (!Strings.isNullOrEmpty((String)updated.getKeyName()) && !updated.getKeyName().equals(existing.getKeyName())) {
            existing = (SshKeyAuthenticationType)updated.copy();
        } else if (updated.isSetPassphrase() && !StringUtils.isEmpty((String)updated.getPassphrase())) {
            existing.setPassphrase(updated.getPassphrase());
        }
        return existing;
    }

    private RepositoryUpdateResult updateGit(RepositoryType existing, RepositoryType updated) {
        RepositoryUpdateResult updateResult = this.checkForGitRestartReindex(existing.getGit(), updated.getGit());
        GitRepType editing = existing.getGit();
        GitRepType git = updated.getGit();
        editing.setLocation(git.getLocation());
        editing.setPath(git.getPath());
        if (git.isSetBlocksize()) {
            editing.setBlocksize(git.getBlocksize());
        } else if (editing.isSetBlocksize()) {
            editing.unsetBlocksize();
        }
        if (git.isSetCommandTimeout()) {
            editing.setCommandTimeout(git.getCommandTimeout());
        } else if (editing.isSetCommandTimeout()) {
            editing.unsetCommandTimeout();
        }
        editing.setRenames(git.getRenames());
        if (git.isSetPasswordAuth()) {
            editing.setPasswordAuth(this.updatePasswordAuth(editing.getPasswordAuth(), git.getPasswordAuth()));
            if (editing.isSetSshAuth()) {
                editing.unsetSshAuth();
            }
        } else if (git.isSetSshAuth()) {
            editing.setSshAuth(this.updateSshAuth(editing.getSshAuth(), git.getSshAuth()));
            if (editing.isSetPasswordAuth()) {
                editing.unsetPasswordAuth();
            }
        } else {
            if (editing.isSetPasswordAuth()) {
                editing.unsetPasswordAuth();
            }
            if (editing.isSetSshAuth()) {
                editing.unsetSshAuth();
            }
        }
        return updateResult;
    }

    private RepositoryUpdateResult updateHg(RepositoryType existing, RepositoryType updated) {
        RepositoryUpdateResult updateResult = this.checkForHgRestartReindex(existing.getHg(), updated.getHg());
        HgRepType editing = existing.getHg();
        HgRepType hg = updated.getHg();
        editing.setLocation(hg.getLocation());
        if (hg.isSetBlocksize()) {
            editing.setBlocksize(hg.getBlocksize());
        } else if (editing.isSetBlocksize()) {
            editing.unsetBlocksize();
        }
        if (hg.isSetCommandTimeout()) {
            editing.setCommandTimeout(hg.getCommandTimeout());
        } else if (editing.isSetCommandTimeout()) {
            editing.unsetCommandTimeout();
        }
        if (hg.isSetPasswordAuth()) {
            editing.setPasswordAuth(this.updatePasswordAuth(editing.getPasswordAuth(), hg.getPasswordAuth()));
            if (editing.isSetSshAuth()) {
                editing.unsetSshAuth();
            }
        } else if (hg.isSetSshAuth()) {
            editing.setSshAuth(this.updateSshAuth(editing.getSshAuth(), hg.getSshAuth()));
            if (editing.isSetPasswordAuth()) {
                editing.unsetPasswordAuth();
            }
        } else {
            if (editing.isSetPasswordAuth()) {
                editing.unsetPasswordAuth();
            }
            if (editing.isSetSshAuth()) {
                editing.unsetSshAuth();
            }
        }
        return updateResult;
    }

    private boolean gitRenameOptionsEqual(GitRepType current, GitRepType git) {
        return ((RenameOptions.Enum)((Object)Objects.firstNonNull((Object)((Object)current.getRenames()), (Object)((Object)RenameOptions.NONE)))).intValue() == ((RenameOptions.Enum)((Object)Objects.firstNonNull((Object)((Object)git.getRenames()), (Object)((Object)RenameOptions.NONE)))).intValue();
    }

    RepositoryUpdateResult checkForGitRestartReindex(GitRepType current, GitRepType git) {
        boolean restart = false;
        boolean reindex = false;
        if (!(DefaultRepositoryAdminService.numbersEqual(current.getBlocksize(), git.getBlocksize()) && StringUtil.equalsWithNullsAsEmpty(current.getCommandTimeout(), git.getCommandTimeout()) && StringUtil.equalsWithNullsAsEmpty(current.getLocation(), git.getLocation()) && this.gitRenameOptionsEqual(current, git))) {
            restart = true;
        }
        if (!StringUtil.equalsWithNullsAsEmpty(current.getPath(), git.getPath())) {
            reindex = true;
        }
        return new RepositoryUpdateResult(restart, reindex);
    }

    RepositoryUpdateResult checkForHgRestartReindex(HgRepType current, HgRepType hg) {
        boolean restart = false;
        boolean reindex = false;
        if (!(DefaultRepositoryAdminService.numbersEqual(current.getBlocksize(), hg.getBlocksize()) && StringUtil.equalsWithNullsAsEmpty(current.getCommandTimeout(), hg.getCommandTimeout()) && StringUtil.equalsWithNullsAsEmpty(current.getLocation(), hg.getLocation()))) {
            restart = true;
        }
        return new RepositoryUpdateResult(restart, false);
    }

    private RepositoryUpdateResult updateP4(RepositoryType existing, RepositoryType updated) {
        RepositoryUpdateResult updateResult = this.checkForP4RestartReindex(existing.getPerforce(), updated.getPerforce());
        P4RepType p4Editing = existing.getPerforce();
        P4RepType p4 = updated.getPerforce();
        p4Editing.setServer(p4.getServer());
        p4Editing.setPath(p4.getPath());
        if (p4.isSetPort()) {
            p4Editing.setPort(p4.getPort());
        } else if (p4Editing.isSetPort()) {
            p4Editing.unsetPort();
        }
        if (p4.isSetBlocksize()) {
            p4Editing.setBlocksize(p4.getBlocksize());
        } else if (p4Editing.isSetBlocksize()) {
            p4Editing.unsetBlocksize();
        }
        if (p4.isSetFileloglimit()) {
            p4Editing.setFileloglimit(p4.getFileloglimit());
        } else if (p4Editing.isSetFileloglimit()) {
            p4Editing.unsetFileloglimit();
        }
        if (p4.isSetCharset()) {
            p4Editing.setCharset(p4.getCharset());
        } else if (p4Editing.isSetCharset()) {
            p4Editing.unsetCharset();
        }
        if (p4.isSetAuth()) {
            p4Editing.setAuth(p4.getAuth());
        } else if (p4Editing.isSetAuth()) {
            p4Editing.unsetAuth();
        }
        if (p4.isSetCps()) {
            p4Editing.setCps(p4.getCps());
        } else if (p4Editing.isSetCps()) {
            p4Editing.unsetCps();
        }
        if (p4.isSetCommandTimeout()) {
            p4Editing.setCommandTimeout(p4.getCommandTimeout());
        } else if (p4Editing.isSetCommandTimeout()) {
            p4Editing.unsetCommandTimeout();
        }
        if (p4.getStartRev() == null && p4Editing.isSetStartRev()) {
            p4Editing.unsetStartRev();
        } else if (p4.getStartRev() != null && p4.isSetStartRev()) {
            p4Editing.setStartRev(p4.getStartRev());
        }
        p4Editing.setInitialImport(p4.getInitialImport());
        p4Editing.setUnicode(p4.getUnicode());
        p4Editing.setSkipLabels(p4.getSkipLabels());
        p4Editing.setCasesensitive(p4.getCasesensitive());
        p4Editing.setDisableMulti(p4.getDisableMulti());
        return updateResult;
    }

    RepositoryUpdateResult checkForP4RestartReindex(P4RepType current, P4RepType p4) {
        boolean restart = false;
        boolean reindex = false;
        if (!(current.getCps() == p4.getCps() && DefaultRepositoryAdminService.numbersEqual(current.getPort(), p4.getPort()) && StringUtil.equalsWithNullsAsEmpty(current.getPath(), p4.getPath()) && StringUtil.equalsWithNullsAsEmpty(current.getServer(), p4.getServer()) && DefaultRepositoryAdminService.numbersEqual(current.getBlocksize(), p4.getBlocksize()) && DefaultRepositoryAdminService.numbersEqual(current.getFileloglimit(), p4.getFileloglimit()) && StringUtil.equalsWithNullsAsEmpty(current.getCharset(), p4.getCharset()) && StringUtil.equalsWithNullsAsEmpty(current.getCommandTimeout(), p4.getCommandTimeout()) && DefaultRepositoryAdminService.authsEqual(current.getAuth(), p4.getAuth()))) {
            restart = true;
        }
        if (current.getUnicode() != p4.getUnicode()) {
            reindex = true;
        }
        if (current.getCasesensitive() != p4.getCasesensitive()) {
            reindex = true;
        }
        if (!current.getInitialImport() && p4.getInitialImport() && p4.isSetStartRev()) {
            reindex = true;
        }
        if (current.isSetStartRev() && !current.getStartRev().equals(p4.getStartRev())) {
            reindex = true;
        }
        return new RepositoryUpdateResult(restart, reindex);
    }

    private RepositoryUpdateResult updateCvs(RepositoryType existing, RepositoryType updated) {
        CvsRepType existingCvs = existing.getCvs();
        CvsRepType updatedCvs = updated.getCvs();
        RepositoryUpdateResult updateResult = this.checkForCvsRestartReindex(existingCvs, updatedCvs);
        existingCvs.setDir(updatedCvs.getDir());
        if (updatedCvs.isSetCharset()) {
            existingCvs.setCharset(updatedCvs.getCharset());
        } else if (existingCvs.isSetCharset()) {
            existingCvs.unsetCharset();
        }
        return updateResult;
    }

    RepositoryUpdateResult checkForCvsRestartReindex(CvsRepType existingCvs, CvsRepType updatedCvs) {
        return new RepositoryUpdateResult(!StringUtil.equalsWithNullsAsEmpty(existingCvs.getDir(), updatedCvs.getDir()), !StringUtil.equalsWithNullsAsEmpty(existingCvs.getDir(), updatedCvs.getDir()));
    }

    private RepositoryUpdateResult updateSvn(RepositoryType existing, RepositoryType updated) {
        SvnRepType existingSvn = existing.getSvn();
        SvnRepType updatedSvn = updated.getSvn();
        RepositoryUpdateResult updateResult = this.checkForSvnRestartReindex(existingSvn, updatedSvn);
        existingSvn.setUrl(updatedSvn.getUrl());
        existingSvn.setPath(updatedSvn.getPath());
        if (updatedSvn.isSetBlocksize()) {
            existingSvn.setBlocksize(updatedSvn.getBlocksize());
        } else if (existingSvn.isSetBlocksize()) {
            existingSvn.unsetBlocksize();
        }
        if (updatedSvn.isSetCharset()) {
            existingSvn.setCharset(updatedSvn.getCharset());
        } else if (existingSvn.isSetCharset()) {
            existingSvn.unsetCharset();
        }
        if (StringUtils.isEmpty((String)updatedSvn.getAccess()) && existingSvn.isSetAccess()) {
            existingSvn.unsetAccess();
        } else if (!StringUtils.isEmpty((String)updatedSvn.getAccess()) && updatedSvn.isSetAccess()) {
            existingSvn.setAccess(updatedSvn.getAccess());
        }
        if (updatedSvn.getStartRev() == null && existingSvn.isSetStartRev()) {
            existingSvn.unsetStartRev();
        } else if (updatedSvn.getStartRev() != null && updatedSvn.isSetStartRev()) {
            existingSvn.setStartRev(updatedSvn.getStartRev());
        }
        existingSvn.setFollowBase(updatedSvn.getFollowBase());
        if (updatedSvn.isSetInitialImport()) {
            existingSvn.setInitialImport(updatedSvn.getInitialImport());
        } else if (existingSvn.isSetInitialImport()) {
            existingSvn.unsetInitialImport();
        }
        if (updatedSvn.isSetAuth()) {
            existingSvn.setAuth(updatedSvn.getAuth());
        } else if (existingSvn.isSetAuth()) {
            existingSvn.unsetAuth();
        }
        if (updatedSvn.isSetCps()) {
            existingSvn.setCps(updatedSvn.getCps());
        } else if (existingSvn.isSetCps()) {
            existingSvn.unsetCps();
        }
        if (updatedSvn.isSetCommandTimeout()) {
            existingSvn.setCommandTimeout(updatedSvn.getCommandTimeout());
        } else if (existingSvn.isSetCommandTimeout()) {
            existingSvn.unsetCommandTimeout();
        }
        existingSvn.setSymbolic(updatedSvn.getSymbolic());
        return updateResult;
    }

    static RepositoryUpdateResult checkForCommonRestartReindex(RepositoryType existing, RepositoryType updated) {
        boolean restart = false;
        boolean reindex = false;
        if (!existing.isSetStoreDiff()) {
            existing.setStoreDiff(true);
        }
        if (existing.getStoreDiff() != updated.getStoreDiff()) {
            reindex = true;
        }
        return new RepositoryUpdateResult(false, reindex);
    }

    RepositoryUpdateResult checkForSvnRestartReindex(SvnRepType existingSvn, SvnRepType updatedSvn) {
        boolean restart = false;
        boolean reindex = false;
        if (existingSvn.getCommandTimeout() == null) {
            existingSvn.setCommandTimeout("");
        }
        if (!(existingSvn.getCps() == updatedSvn.getCps() && StringUtil.equalsWithNullsAsEmpty(existingSvn.getPath(), updatedSvn.getPath()) && StringUtil.equalsWithNullsAsEmpty(existingSvn.getUrl(), updatedSvn.getUrl()) && DefaultRepositoryAdminService.numbersEqual(existingSvn.getBlocksize(), updatedSvn.getBlocksize()) && StringUtil.equalsWithNullsAsEmpty(existingSvn.getCharset(), updatedSvn.getCharset()) && StringUtil.equalsWithNullsAsEmpty(existingSvn.getAccess(), updatedSvn.getAccess()) && StringUtil.equalsWithNullsAsEmpty(existingSvn.getCommandTimeout(), updatedSvn.getCommandTimeout()) && DefaultRepositoryAdminService.authsEqual(existingSvn.getAuth(), updatedSvn.getAuth()))) {
            restart = true;
        }
        if (existingSvn.getFollowBase() != updatedSvn.getFollowBase() || !DefaultRepositoryAdminService.numbersEqual(existingSvn.getStartRev(), updatedSvn.getStartRev())) {
            reindex = true;
        }
        try {
            SvnLogicalPathMatcher currentMatcher = new SvnLogicalPathMatcher(existingSvn.getSymbolic());
            SvnLogicalPathMatcher newMatcher = new SvnLogicalPathMatcher(updatedSvn.getSymbolic());
            if (!currentMatcher.equals(newMatcher)) {
                reindex = true;
            }
        }
        catch (ConfigException e2) {
            reindex = true;
        }
        if (!updatedSvn.isSetInitialImport() || ImportMode.fromString((String)updatedSvn.getInitialImport()) == ImportMode.NO_IMPORT) {
            if (existingSvn.isSetInitialImport() && ImportMode.fromString((String)existingSvn.getInitialImport()) != ImportMode.NO_IMPORT) {
                reindex = true;
            }
        } else if (!StringUtil.equalsWithNullsAsEmpty(existingSvn.getInitialImport(), updatedSvn.getInitialImport())) {
            reindex = true;
        }
        return new RepositoryUpdateResult(restart, reindex);
    }

    static boolean authsEqual(UserPassAuthType a1, UserPassAuthType a2) {
        if (a1 == a2) {
            return true;
        }
        String a1Username = a1 == null ? null : a1.getUsername();
        String a2Username = a2 == null ? null : a2.getUsername();
        String a1Password = a1 == null ? null : a1.getPassword();
        String a2Password = a2 == null ? null : a2.getPassword();
        return StringUtil.equalsWithNullsAsEmpty(a1Username, a2Username) && StringUtil.equalsWithNullsAsEmpty(a1Password, a2Password);
    }

    static boolean numbersEqual(Number num1, Number num2) {
        if (num1 == num2) {
            return true;
        }
        if (num1 == null || num2 == null) {
            return false;
        }
        return num1.equals(num2);
    }

    public RepositoryState getState(String name) {
        this.ensureAdminPermission();
        if (!this.isEnabled(name)) {
            throw new IllegalStateException(String.format("Repository '%s' must be enabled.", name));
        }
        RepositoryHandle rep = this.getRepositoryHandle(name);
        if (rep.isStopped()) {
            return RepositoryState.STOPPED;
        }
        if (rep.isStopping()) {
            return RepositoryState.STOPPING;
        }
        if (rep.isRunning()) {
            return RepositoryState.RUNNING;
        }
        if (rep.isStarting()) {
            return RepositoryState.STARTING;
        }
        throw new AssertionError((Object)String.format("Unknown repository state: %s", rep.getStateDescription()));
    }

    public boolean isManaged(String name) {
        return false;
    }

    public boolean isPipelined(String name) {
        return this.getRepositoryHandle(name).isPipelined();
    }

    public boolean isEnabled(String name) {
        return this.getRepositoryHandle(name).getCfg().isEnabled();
    }

    public void enable(String name) throws RepositoryConfigException {
        this.ensureAdminPermission();
        if (this.isEnabled(name)) {
            return;
        }
        this.configLock.lock();
        try {
            RepositoryType repository = AppConfig.getsConfig().getConfig().getRepositoryArray(AdminSpiUtil.configIndex(name));
            repository.setEnabled(true);
            this.saveConfig();
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable(String name) throws RepositoryConfigException {
        this.ensureAdminPermission();
        RepositoryState state = this.getState(name);
        if (state != RepositoryState.STOPPED) {
            throw new IllegalStateException(String.format("Repository '%s' (currently '%s') must be stopped before disabling.", name, state));
        }
        this.getRepositoryHandle(name).getStatus().reset();
        this.configLock.lock();
        try {
            RepositoryType repository = AppConfig.getsConfig().getConfig().getRepositoryArray(AdminSpiUtil.configIndex(name));
            repository.setEnabled(false);
            this.saveConfig();
        }
        finally {
            this.configLock.unlock();
        }
    }

    public RepositoryState stop(String name) {
        this.ensureStoppable(name);
        Logs.APP_LOG.debug((Object)String.format("Stop triggered for repository %s", name));
        this.getRepositoryHandle(name).stop();
        return this.getState(name);
    }

    public RepositoryState stopAndWait(String name, long timeoutMs) {
        this.ensureStoppable(name);
        this.getRepositoryHandle(name).tryStop(timeoutMs);
        return this.getState(name);
    }

    public RepositoryState stopAndWait(String name) {
        return this.stopAndWait(name, 20000L);
    }

    private void ensureStoppable(String name) {
        this.ensureAdminPermission();
        RepositoryState state = this.getState(name);
        if (state != RepositoryState.RUNNING) {
            throw new IllegalStateException(String.format("Repository '%s' (currently %s) must be running before stopping.", name, state));
        }
    }

    public RepositoryState start(String name) throws RepositoryConfigException {
        this.ensureAdminPermission();
        Logs.APP_LOG.debug((Object)String.format("Start triggered for repository %s", name));
        RepositoryState state = this.getState(name);
        if (state != RepositoryState.STOPPED) {
            throw new IllegalStateException(String.format("Repository '%s' (currently %s) must be stopped before starting.", name, state));
        }
        try {
            this.repositoryManager.runRepository(name);
        }
        catch (ConfigException e2) {
            throw new RepositoryConfigException(String.format("Problem loading repository '%s' - %s.", name, e2.getMessage()), (Throwable)e2);
        }
        catch (RepositoryHandle.StateException e3) {
            throw new AssertionError((Object)String.format("Repository '%s' is already stopped.", name));
        }
        catch (DbException e4) {
            throw new RepositoryConfigException((Throwable)e4);
        }
        catch (IOException e5) {
            throw new RepositoryConfigException((Throwable)e5);
        }
        catch (LicensePolicyException e6) {
            throw new RepositoryConfigException((Throwable)e6);
        }
        return this.getState(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String name) throws RepositoryConfigException {
        RepositoryState state;
        this.ensureAdminPermission();
        if (!this.exists(name)) {
            throw new NotFoundException(String.format("Repository %s not found.", name));
        }
        if (this.isEnabled(name) && (state = this.getState(name)) != RepositoryState.STOPPED) {
            throw new IllegalStateException(String.format("Repository '%s' disabled or stopped (currently %s) before deleting.", name, state));
        }
        RepositoryConfig repoConfig = this.getRepositoryHandle(name).getCfg();
        RepositoryType repoType = repoConfig.getRepositoryTypeConfig();
        String sshKeyName = this.getSshKeyName(repoType);
        String typeName = AdminSpiUtil.getType((RepositoryType)repoType).name;
        this.configLock.lock();
        try {
            AppConfig.getsConfig().getConfig().removeRepository(AdminSpiUtil.configIndex(name));
            this.saveConfig();
        }
        finally {
            this.configLock.unlock();
        }
        this.removeRepoStorage(repoConfig);
        this.eventPublisher.publish((Object)new RepositoryDeletedEventImpl(name, typeName));
        try {
            this.repositoryManager.reloadList();
        }
        catch (ConfigException e2) {
            throw new RepositoryConfigException(String.format("Problem reloading configuration when deleting '%s'.", name), (Throwable)e2);
        }
        if (StringUtils.isNotEmpty((String)sshKeyName)) {
            this.sshKeyManager.removeKey(sshKeyName);
        }
    }

    private void removeRepoStorage(RepositoryConfig repoConfig) {
        FileUtils.deleteTree(repoConfig.getCacheDir());
        FileUtils.deleteTree(repoConfig.getTempDir());
        FileUtils.deleteTree(new File(AppConfig.getDiffTextCacheDir(), repoConfig.getName()));
    }

    public RepositoryIndexer getIndexer(String name) {
        this.ensureAdminPermission();
        RepositoryHandle repositoryHandle = this.getRepositoryHandle(name);
        ScmType type = repositoryHandle.getCfg().getRepositoryType();
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Unknown repository type '%s'.", (Object[])new Object[]{name});
        return type.getDefaultRepositoryIndexer(this, repositoryHandle);
    }

    public void disablePolling(String name) throws RepositoryConfigException {
        this.ensureAdminPermission();
        RepositoryHandle repositoryHandle = this.getRepositoryHandle(name);
        PolledUpdaterType updater = AdminSpiUtil.getPolledRepoUpdater(repositoryHandle.getCfg().getRepositoryTypeConfig(), true);
        updater.setPollPeriod("never");
        this.saveConfig();
    }

    private void ensureAdminPermission() {
        if (!this.effectiveUserProvider.isAdmin() && !Principal.SuperUser.isSuperUser((Principal)this.effectiveUserProvider.getEffectivePrincipal())) {
            throw new NotPermittedException("You are not authorized to perform this operation");
        }
    }

    private RepositoryHandle getRepositoryHandle(String name) {
        RepositoryHandle handle = this.repositoryManager.getRepository(name);
        if (handle == null) {
            throw new NotFoundException(String.format("Repository '%s' does not exist.", name));
        }
        return handle;
    }

    private void saveConfig() throws RepositoryConfigException {
        this.configLock.lock();
        try {
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            throw new RepositoryConfigException("Problem saving configuration.", (Throwable)e2);
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullReindex(String repositoryName, boolean clone) throws RepositoryConfigException, TimeoutException {
        this.ensureAdminPermission();
        Logs.APP_LOG.debug((Object)String.format("Full reindex triggered for repository %s", repositoryName));
        Disposer.pushThreadInstance();
        try {
            boolean wasRunning;
            boolean bl = wasRunning = this.getState(repositoryName) == RepositoryState.RUNNING;
            if (wasRunning && this.stopAndWait(repositoryName, 20000L) != RepositoryState.STOPPED) {
                throw new TimeoutException(String.format("Timed out waiting for the repository %s to stop", repositoryName));
            }
            RepositoryIndexer indexer = this.getIndexer(repositoryName);
            if (indexer instanceof DefaultDvcsRepositoryIndexer) {
                ((DefaultDvcsRepositoryIndexer)indexer).startFullReindexing(clone);
            } else {
                indexer.startFullReindexing();
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public void reindexReviews(String repositoryName) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Reindex reviews triggered for repository %s", repositoryName));
        this.getRepoHandle(repositoryName).requestCrucibleReindex(false);
    }

    public void reindexLineCount(String repositoryName) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Reindex linecounts triggered for repository %s", repositoryName));
        this.getRepoHandle(repositoryName).requestLinecountReindex();
    }

    public void reindexSearch(String repositoryName) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Reindex search triggered for repository %s", repositoryName));
        this.getRepoHandle(repositoryName).requestCrossRepositoryRescan(true);
    }

    public void reindexChangesetDiscussion(String repositoryName) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Reindex changeset discussions requested for repository %s", repositoryName));
        this.getRepoHandle(repositoryName).requestChangesetCommentReindex();
    }

    public void incrementalIndex(String repositoryName, boolean wait) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Incremental index triggered for repository %s", repositoryName));
        this.getRepoHandle(repositoryName).oneOffScan(wait);
    }

    public void fullIncrementalIndex(String repositoryName) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Full incremental index triggered for repository %s", repositoryName));
        RepositoryIndexer indexer = this.getIndexer(repositoryName);
        if (indexer instanceof CvsRepositoryIndexer) {
            ((CvsRepositoryIndexer)indexer).startFullScan();
        } else {
            this.incrementalIndex(repositoryName, false);
        }
    }

    public void rescanMetadata(String repositoryName, String fromRevision, String toRevision) throws RepositoryStateException {
        this.ensureAdminPermission();
        this.verifyRunning(repositoryName);
        Logs.APP_LOG.debug((Object)String.format("Metadata rescan triggered for repository %s", repositoryName));
        this.getRepoHandle(repositoryName).rescan(fromRevision, toRevision);
    }

    private void verifyRunning(String repositoryName) throws RepositoryStateException {
        if (!this.isEnabled(repositoryName) || this.getState(repositoryName) != RepositoryState.RUNNING) {
            throw new RepositoryStateException("Repository needs to be enabled and running");
        }
    }

    private RepositoryHandle getRepoHandle(String repositoryName) {
        RepositoryHandle handle = this.repositoryManager.getRepository(repositoryName);
        if (handle == null) {
            throw new NotFoundException("Repository " + repositoryName + " not found");
        }
        return handle;
    }
}

